console.clear();
console.log('Iniciando BOT, Espere...');


const { default: makeWASocket, DisconnectReason, makeInMemoryStore, jidDecode, proto, getContentType, useMultiFileAuthState, downloadContentFromMessage, makeCacheableSignalKeyStore } = require("@whiskeysockets/baileys");
const pino = require('pino');
const { Boom } = require('@hapi/boom');
const fs = require('fs');
const readline = require("readline");
const PhoneNumber = require('awesome-phonenumber');
const fetch = require('node-fetch'); // ✅ Importación necesaria para usar fetch
const qrcode = require('qrcode-terminal'); // ✅ Para mostrar QR manualmente
//const iniciarTareasAutomaticas = require('./lib/autotask.js');
const path = require('path');

const usePairingCode = false;
const store = makeInMemoryStore({ logger: pino().child({ level: 'silent', stream: 'store' }) });
const question = (text) => {
    const rl = readline.createInterface({ input: process.stdin, output: process.stdout });
    return new Promise((resolve) => rl.question(text, resolve));
};

// Ruta del archivo de usuarios conocidos
const usuariosPath = path.join(__dirname, '../database/usuarios.json');

// Cargar o inicializar la lista de usuarios conocidos
function getUsuarios() {
    if (!fs.existsSync(usuariosPath)) return [];
    try {
        return JSON.parse(fs.readFileSync(usuariosPath, 'utf8'));
    } catch (e) {
        console.error('Error leyendo usuarios:', e);
        return [];
    }
}

function guardarUsuarios(lista) {
    const dir = path.dirname(usuariosPath);
    if (!fs.existsSync(dir)) {
        fs.mkdirSync(dir, { recursive: true }); // 🔧 Crea la carpeta si no existe
    }
    fs.writeFileSync(usuariosPath, JSON.stringify(lista, null, 2));
}

// Ruta del archivo de configuración del menú
const CONFIG_PATH = path.join(__dirname, '../database/menu_config.json');

function getMenuActual() {
    if (!fs.existsSync(CONFIG_PATH)) return 1;
    const data = JSON.parse(fs.readFileSync(CONFIG_PATH));
    return data.menuActual || 1;
}

function setMenuActual(numero) {
    fs.writeFileSync(CONFIG_PATH, JSON.stringify({ menuActual: numero }, null, 2));
}

// Función para conecytar el cliente de WhatsApp
// y manejar el emparejamiento con código de emparejamiento
// Si usePairingCode es true, solicitará el número de WhatsApp y generará un código de emparejamiento
// Si usePairingCode es false, se conectará directamente con las credenciales guardadas en la carpeta "session"
// Si la carpeta "session" no existe, se creará automáticamente al iniciar el cliente
// Si la carpeta "session" ya existe, se utilizarán las credenciales guardadas en ella
// Si la conexión se pierde, intentará reconectarse automáticamente
// Si la conexión se cierra, mostrará un mensaje indicando que la sesión ha sido cerrada
// Si la conexión se abre, mostrará un mensaje indicando que se ha conectado correctamente
// Si se recibe un mensaje, lo procesará y enviará una respuesta automática si es necesario
async function StartclientArchive() {
    const { state, saveCreds } = await useMultiFileAuthState("session");

    const versionData = await (await fetch('https://raw.githubusercontent.com/WhiskeySockets/Baileys/master/src/Defaults/baileys-version.json')).json();
    const version = versionData.version;

    const client = makeWASocket({
        printQRInTerminal: !usePairingCode,
        syncFullHistory: true,
        markOnlineOnConnect: true,
        connectTimeoutMs: 60000,
        defaultQueryTimeoutMs: 0,
        keepAliveIntervalMs: 10000,
        generateHighQualityLinkPreview: true,
        patchMessageBeforeSending: (message) => {
            const requiresPatch = !!(
                message.buttonsMessage ||
                message.templateMessage ||
                message.listMessage
            );
            if (requiresPatch) {
                message = {
                    viewOnceMessage: {
                        message: {
                            messageContextInfo: {
                                deviceListMetadataVersion: 2,
                                deviceListMetadata: {},
                            },
                            ...message,
                        },
                    },
                };
            }
            return message;
        },
        version,
        browser: ["BOT SOPORTE Y APORTES", "WhatsApp", "1.0"],
        logger: pino({ level: 'fatal' }),
        auth: {
            creds: state.creds,
            keys: makeCacheableSignalKeyStore(state.keys, pino().child({ level: 'silent', stream: 'store' })),
        }
    });

    if (usePairingCode && !client.authState.creds.registered) {
        const phoneNumber = await question('Por favor ingrese su número de WhatsApp, comenzando con el código de país:\n');
        const code = await client.requestPairingCode(phoneNumber, global.pairing);
        console.log(`Tu código de emparejamiento es: ${code}`);
    }

    store.bind(client.ev);

    client.ev.on('connection.update', (update) => {
        const { qr, connection, lastDisconnect } = update;

        // ✅ Mostrar QR manualmente si existe
        if (qr) {
            qrcode.generate(qr, { small: true });
        }

        if (connection === 'close') {
            const reason = new Boom(lastDisconnect?.error)?.output.statusCode;
            switch (reason) {
                case DisconnectReason.badSession:
                case DisconnectReason.connectionClosed:
                case DisconnectReason.connectionLost:
                case DisconnectReason.connectionReplaced:
                case DisconnectReason.restartRequired:
                case DisconnectReason.timedOut:
                    console.log('🔁 Reconectando...');
                    StartclientArchive();
                    break;
                case DisconnectReason.loggedOut:
                    console.log('🚪 Sesión cerrada. Elimina la carpeta "session" para volver a conectar.');
                    break;
                default:
                    console.log(`❓ Desconectado: ${reason} | ${connection}`);
                    break;
            }
        } else if (connection === 'open') {
			//iniciarTareasAutomaticas(client); // ✅ Solo una vez
            console.log('[✅ Conectado como]', JSON.stringify(client.user.id, null, 2));
        }
    });

    client.ev.on('messages.upsert', async chatUpdate => {
        try {
            let mek = chatUpdate.messages[0];
            if (!mek.message) return;
            mek.message = (Object.keys(mek.message)[0] === 'ephemeralMessage') ? mek.message.ephemeralMessage.message : mek.message;
            if (mek.key && mek.key.remoteJid === 'status@broadcast') return;
            if (!client.public && !mek.key.fromMe && chatUpdate.type === 'notify') return;
            if (mek.key.id.startsWith('BAE5') && mek.key.id.length === 16) return;
            const m = smsg(client, mek, store);
            //require("./case")(client, m, chatUpdate, store);
        } catch (err) {
            console.log(err);
        }
    });

    client.ev.on('creds.update', saveCreds);

// Evento de mensajes entrantes
client.ev.on('messages.upsert', async (msg) => {
    const mensaje = msg.messages[0];
    if (!mensaje.message || mensaje.key.fromMe) return;

    const sender = mensaje.key.remoteJid;
    const texto = mensaje.message.conversation?.toLowerCase() || mensaje.message.extendedTextMessage?.text?.toLowerCase();

    // Verificar si es un nuevo usuario
    let usuarios = getUsuarios(); // <- tu función existente
    if (!usuarios.includes(sender)) {
        usuarios.push(sender);
        guardarUsuarios(usuarios); // <- tu función existente

        await client.sendMessage(sender, {
            text: `👋 *Bienvenidos a Restaurante Cantares*\n¿Me gustaría tomar su orden?\n\n📋 Escriba *menu del dia* para ver el menú actual.`
        });
        return;
    }

    // Comando para establecer el menú del día: fotomenu 2
    const matchFotoMenu = texto.match(/fotomenu\s*#?(\d+)/);
    if (matchFotoMenu) {
        const numero = parseInt(matchFotoMenu[1]);
        const extensiones = ['.jpg', '.jpeg', '.png'];
        let rutaImagen = null;

        for (let ext of extensiones) {
            const tempPath = path.join(__dirname, 'menu', `menu${numero}${ext}`);
            if (fs.existsSync(tempPath)) {
                rutaImagen = tempPath;
                break;
            }
        }

        if (rutaImagen) {
            setMenuActual(numero);
            await client.sendMessage(sender, {
                text: `✅ *Menú del Día* actualizado al menú #${numero}.`
            });
        } else {
            await client.sendMessage(sender, {
                text: `❌ No se encontró la imagen del menú #${numero}. Verifica que el archivo exista en /menu.`
            });
        }
        return;
    }

    // Comando para ver el menú del día actual
    if (texto.includes('menu del dia')) {
        const numero = getMenuActual();
        const extensiones = ['.jpg', '.jpeg', '.png'];
        let rutaImagen = null;

        for (let ext of extensiones) {
            const tempPath = path.join(__dirname, 'menu', `menu${numero}${ext}`);
            if (fs.existsSync(tempPath)) {
                rutaImagen = tempPath;
                break;
            }
        }

        if (rutaImagen) {
            const buffer = fs.readFileSync(rutaImagen);
            await client.sendMessage(sender, {
                image: buffer,
                caption: `🍽️ *Menú del Día #${numero}*\n\n¡Esperamos su orden!`
            });
        } else {
            await client.sendMessage(sender, {
                text: `⚠️ El menú #${numero} está configurado pero no se encontró su imagen en la carpeta /menu.`
            });
        }
        return;
    }

    // Respuesta a "hola"
    if (texto === 'hola' || texto === 'buenas' || texto === 'buenos días' || texto === 'buenas tardes' || texto === 'Hola') {
        await client.sendMessage(sender, {
            text: `👋 *Bienvenidos a Restaurante Cantares*\n\n📋 Escriba *menu del dia* para ver el menú actual.`
        });
    }
});
	
    client.decodeJid = (jid) => {
        if (!jid) return jid;
        if (/:\d+@/gi.test(jid)) {
            const decode = jidDecode(jid) || {};
            return (decode.user && decode.server) ? `${decode.user}@${decode.server}` : jid;
        } else return jid;
    };

    client.getName = (jid, withoutContact = false) => {
        const id = client.decodeJid(jid);
        withoutContact = client.withoutContact || withoutContact;
        let v;
        if (id.endsWith("@g.us")) return new Promise(async (resolve) => {
            v = store.contacts[id] || {};
            if (!(v.name || v.subject)) v = await client.groupMetadata(id) || {};
            resolve(v.name || v.subject || PhoneNumber('+' + id.replace('@s.whatsapp.net', '')).getNumber('international'));
        });
        else {
            v = (id === '0@s.whatsapp.net')
                ? { id, name: 'WhatsApp' }
                : (id === client.decodeJid(client.user.id)
                    ? client.user
                    : (store.contacts[id] || {}));
            return (withoutContact ? '' : v.name) || v.subject || v.verifiedName || PhoneNumber('+' + jid.replace('@s.whatsapp.net', '')).getNumber('international');
        }
    };

    client.public = true;

    client.serializeM = (m) => smsg(client, m, store);

    client.sendText = (jid, text, quoted = '', options = {}) => client.sendMessage(jid, { text: text, ...options }, { quoted });

    client.downloadMediaMessage = async (message) => {
        const mime = (message.msg || message).mimetype || '';
        const messageType = message.mtype ? message.mtype.replace(/Message/gi, '') : mime.split('/')[0];
        const stream = await downloadContentFromMessage(message, messageType);
        let buffer = Buffer.from([]);
        for await (const chunk of stream) {
            buffer = Buffer.concat([buffer, chunk]);
        }
        return buffer;
    };

    return client;
}

StartclientArchive();

function smsg(client, m, store) {
if (!m) return m
let M = proto.WebMessageInfo
if (m.key) {
m.id = m.key.id
m.isBaileys = m.id.startsWith('BAE5') && m.id.length === 16
m.chat = m.key.remoteJid
m.fromMe = m.key.fromMe
m.isGroup = m.chat.endsWith('@g.us')
m.sender = client.decodeJid(m.fromMe && client.user.id || m.participant || m.key.participant || m.chat || '')
if (m.isGroup) m.participant = client.decodeJid(m.key.participant) || ''
}
if (m.message) {
m.mtype = getContentType(m.message)
m.msg = (m.mtype == 'viewOnceMessage' ? m.message[m.mtype].message[getContentType(m.message[m.mtype].message)] : m.message[m.mtype])
m.body = m.message.conversation || m.msg.caption || m.msg.text || (m.mtype == 'listResponseMessage') && m.msg.singleSelectReply.selectedRowId || (m.mtype == 'buttonsResponseMessage') && m.msg.selectedButtonId || (m.mtype == 'viewOnceMessage') && m.msg.caption || m.text
let quoted = m.quoted = m.msg.contextInfo ? m.msg.contextInfo.quotedMessage : null
m.mentionedJid = m.msg.contextInfo ? m.msg.contextInfo.mentionedJid : []
if (m.quoted) {
let type = getContentType(quoted)
m.quoted = m.quoted[type]
if (['productMessage'].includes(type)) {
type = getContentType(m.quoted)
m.quoted = m.quoted[type]
}
if (typeof m.quoted === 'string') m.quoted = {
text: m.quoted
}
m.quoted.mtype = type
m.quoted.id = m.msg.contextInfo.stanzaId
m.quoted.chat = m.msg.contextInfo.remoteJid || m.chat
m.quoted.isBaileys = m.quoted.id ? m.quoted.id.startsWith('BAE5') && m.quoted.id.length === 16 : false
m.quoted.sender = client.decodeJid(m.msg.contextInfo.participant)
m.quoted.fromMe = m.quoted.sender === client.decodeJid(client.user.id)
m.quoted.text = m.quoted.text || m.quoted.caption || m.quoted.conversation || m.quoted.contentText || m.quoted.selectedDisplayText || m.quoted.title || ''
m.quoted.mentionedJid = m.msg.contextInfo ? m.msg.contextInfo.mentionedJid : []
m.getQuotedObj = m.getQuotedMessage = async () => {
if (!m.quoted.id) return false
let q = await store.loadMessage(m.chat, m.quoted.id, conn)
 return exports.smsg(conn, q, store)
}
let vM = m.quoted.fakeObj = M.fromObject({
key: {
remoteJid: m.quoted.chat,
fromMe: m.quoted.fromMe,
id: m.quoted.id
},
message: quoted,
...(m.isGroup ? { participant: m.quoted.sender } : {})
})
m.quoted.delete = () => client.sendMessage(m.quoted.chat, { delete: vM.key })
m.quoted.copyNForward = (jid, forceForward = false, options = {}) => client.copyNForward(jid, vM, forceForward, options)
m.quoted.download = () => client.downloadMediaMessage(m.quoted)
}
}
if (m.msg.url) m.download = () => client.downloadMediaMessage(m.msg)
m.text = m.msg.text || m.msg.caption || m.message.conversation || m.msg.contentText || m.msg.selectedDisplayText || m.msg.title || ''
m.reply = (text, chatId = m.chat, options = {}) => Buffer.isBuffer(text) ? client.sendMedia(chatId, text, 'file', '', m, { ...options }) : client.sendText(chatId, text, m, { ...options })
m.copy = () => exports.smsg(conn, M.fromObject(M.toObject(m)))
m.copyNForward = (jid = m.chat, forceForward = false, options = {}) => client.copyNForward(jid, m, forceForward, options)

return m
}

//~~~~~Status Diperbarui~~~~~//
let file = require.resolve(__filename)
fs.watchFile(file, () => {
fs.unwatchFile(file)
console.log(`Update ${__filename}`)
delete require.cache[file]
require(file)
})
