require('../settings/config');
require('dotenv').config();

const fs = require('fs');
const axios = require('axios');
const chalk = require("chalk");
const jimp = require("jimp")
const util = require("util");
const moment = require("moment-timezone");
const path = require('path');
const os = require('os');
const ownernya = owner + '@s.whatsapp.net'
const botsya = bot + '@s.whatsapp.net'
const YTDlpWrap = require("yt-dlp-wrap").default; // Usa .default si hay problemas
const ytDlp = new YTDlpWrap();
const ffmpeg = require("fluent-ffmpeg");
// 📌 Establecer la ruta de ffmpeg manualmente
const ffmpegPath = path.join('./ffmpeg.exe');
ffmpeg.setFfmpegPath(ffmpegPath);
const CronJob = require('cron').CronJob;
const cron = require('node-cron');
//require('./lib/autotask'); // <--- nombre actualizado
const { JSDOM } = require("jsdom");
const groupDBPath = "./database/groupcode.json";
const crypto = require("crypto");
const permisoPath  = "./database/permisos.json";
const { createCanvas, loadImage, registerFont } = require("canvas");
const sharp = require('sharp');
const { wallpaper , pinterest2 } = require('../lib/scraper.js');
const he = require("he");
const { ytDonlodMp3, ytDonlodMp4, ytPlayMp3, ytPlayMp4, ytSearch } = require('../scrape/yt')

// Ruta de la base de datos
const filePath = path.join('./settings/build.js');
const lastUpdateFile = path.join('./settings/lastUpdate.json'); // Archivo para registrar la última actualización

// Función para detectar cambios en el archivo build.js
function archivoModificado() {
    const stats = fs.statSync(filePath);
    return stats.mtimeMs; // Timestamp de última modificación
}

// Guardar la última vez que el archivo fue guardado
function registrarUltimaModificacion(timestamp) {
    fs.writeFileSync(lastUpdateFile, JSON.stringify({ time: timestamp }, null, 2));
}

function incrementarVersion() {
    try {
        // Leer la versión actual del archivo build.js
        let data = JSON.parse(fs.readFileSync(filePath, 'utf-8'));

        // Leer la última modificación registrada
        let lastUpdate = {};
        if (fs.existsSync(lastUpdateFile)) {
            lastUpdate = JSON.parse(fs.readFileSync(lastUpdateFile, 'utf-8'));
        }

        // Obtener la última modificación actual
        let currentModificationTime = archivoModificado();

        // Validar si el archivo fue modificado desde el último registro
        if (lastUpdate.time === currentModificationTime) {
            console.log('⏸️ No hubo cambios en el archivo, la versión no se incrementará.');
            return; // Salir si no hay cambios
        }

        // Incrementar la versión
        let [major, minor] = data.version.split('.').map(Number);
        minor += 1;

        // Reiniciar minor y aumentar major si es necesario
        if (minor >= 10) {
            minor = 0;
            major += 1;
        }

        data.version = `${major}.${minor}`;
        data.build = '24H2';

        // Guardar la nueva versión
        fs.writeFileSync(filePath, JSON.stringify(data, null, 2));

        // Registrar la última modificación
        registrarUltimaModificacion(currentModificationTime);

        console.log(`[✅ ] Versión actualizada: ${data.version}`);
    } catch (error) {
        console.error('❌ Error al actualizar la versión:', error);
    }
}

// Ejecutar la función
incrementarVersion();


const path1 = './database/processedMessages.json';
// ✅ Función para cargar los mensajes procesados
const loadProcessedMessages = () => {
    if (!fs.existsSync(path1)) fs.writeFileSync(path1, JSON.stringify([]));
    return JSON.parse(fs.readFileSync(path1));
};
// ✅ Función para guardar los mensajes procesados
const saveProcessedMessage = (messageId) => {
    let messages = loadProcessedMessages();
    messages.push({ id: messageId, timestamp: Date.now() });
    fs.writeFileSync(path1, JSON.stringify(messages, null, 2));
};
const delay = ms => new Promise(resolve => setTimeout(resolve, ms));
const processedMessages = new Set(); // Guardar mensajes ya procesados

const { SnackVideo } = require('../start/lib/function/snackvideo')
const {spawn, exec, execSync } = require('child_process');

const {
    default:
    baileys,
    getContentType,
	MessageType
   } = require("@whiskeysockets/baileys");

/////////////////////////////////////////////////////////////////////////////////
// Penalizador de mensajes
const STRIKES_DB = './database/strikes.json'; // Ruta de la base de datos de strikes
const userMessages = new Map(); //Almacena los mensajes de cada usuario
const SPAM_LIMIT = 20; //contador de mensajes para penalizar usuario
const TIME_WINDOW = 10000; // 10 segundos para refresco
const MAX_STRIKES = 3; // máximo de strikes

// Cargar strikes desde la base de datos (Evita problemas con estructuras vacías)
let groupStrikes = {};
if (fs.existsSync(STRIKES_DB)) {
    try {
        const data = fs.readFileSync(STRIKES_DB, "utf8");
        groupStrikes = JSON.parse(data);
        
        if (typeof groupStrikes !== "object" || Array.isArray(groupStrikes)) {
            console.error("❌ Formato incorrecto en strikes.json. Se reiniciará.");
            groupStrikes = {};
        } else {
            //console.log("✅ Strikes cargados correctamente desde strikes.json");
        }
    } catch (error) {
        console.error("❌ Error al cargar strikes.json:", error);
        groupStrikes = {};
    }
} else {
    console.log("⚠️ No se encontró strikes.json, se creará uno nuevo.");
    fs.writeFileSync(STRIKES_DB, JSON.stringify({}, null, 2));
}

// Función para guardar strikes en strikes.json
function guardarStrikes() {
    try {
        fs.writeFileSync(STRIKES_DB, JSON.stringify(groupStrikes, null, 2));
        console.log("💾 Strikes guardados correctamente en strikes.json.");
    } catch (error) {
        console.error("❌ Error al guardar strikes.json:", error);
    }
}

// Función para resetear strikes a las 00:00
function resetearStrikes() {
    console.log("⏳ Reseteando strikes a las 00:00...");
    for (let groupId in groupStrikes) {
        for (let userId in groupStrikes[groupId].users) {
            groupStrikes[groupId].users[userId].strikes = 0;
        }
    }
    guardarStrikes();
    console.log("✅ Strikes reseteados a 0.");
}

// Programar reset de strikes a medianoche
function programarReinicio() {
    let ahora = new Date();
    let proximaMedianoche = new Date();
    proximaMedianoche.setHours(24, 0, 0, 0);

    let tiempoHastaMedianoche = proximaMedianoche - ahora;
    setTimeout(() => {
        resetearStrikes();
        programarReinicio();
    }, tiempoHastaMedianoche);
}

programarReinicio();
//fin del penalizador de mensajes
/////////////////////////////////////////////////////////////////////////////////
//Comprobador de grupos
const VALIDATION_DB = "./database/validations.json";
let pendingValidations = {};

// Verificar si el archivo existe antes de cargarlo
if (fs.existsSync(VALIDATION_DB)) {
    try {
        let data = fs.readFileSync(VALIDATION_DB, "utf8").trim();
        pendingValidations = data ? JSON.parse(data) : {};
    } catch (error) {
        console.error("❌ Error al cargar validations.json. Archivo corrupto, se restablecerá.");
        pendingValidations = {};
        fs.writeFileSync(VALIDATION_DB, JSON.stringify({}, null, 2)); // Reiniciar archivo
    }
} else {
    fs.writeFileSync(VALIDATION_DB, JSON.stringify({}, null, 2)); // Crear archivo si no existe
}
// Guardar validaciones en archivo
function guardarValidaciones() {
    fs.writeFileSync(VALIDATION_DB, JSON.stringify(pendingValidations, null, 2));
}

// Generar código de seguridad de 8 dígitos
function generarCodigo() {
    return Math.floor(10000000 + Math.random() * 90000000).toString();
}
//Fin del comprobador de grupos 
/////////////////////////////////////////////////////////////////////////////////

//Función para guardar datos en la base de datos de YouTube
const YT_DB = './database/youtube.json';
//Función para obtener las consultas de un grupo específico
function cargarConsultasDeGrupo(grupo) {
    try {
        if (fs.existsSync(YT_DB)) {
            let db = JSON.parse(fs.readFileSync(YT_DB, 'utf-8'));
            return db[grupo] || null; // Devuelve la última consulta del grupo o null si no existe
        }
        return null;
    } catch (err) {
        console.error("❌ Error al cargar las consultas del grupo:", err);
        return null;
    }
}

// Función para guardar solo la última consulta del grupo específico
function guardarConsultasDeGrupo(grupo, consulta) {
    try {
        let db = fs.existsSync(YT_DB) ? JSON.parse(fs.readFileSync(YT_DB, 'utf-8')) : {};
        
        db[grupo] = consulta; // Sobrescribe la consulta del grupo
        
        fs.writeFileSync(YT_DB, JSON.stringify(db, null, 2));
        console.log(`✅ Consulta del grupo ${grupo} actualizada.`);
    } catch (err) {
        console.error("❌ Error al guardar la consulta del grupo:", err);
    }
}

////////////////////////////////////////////////////////////////////////////////////////
// 📂 Carpeta de JSON original
const sourceFolder = path.join('./database'); // Ajusta según tu carpeta

// 📂 Carpeta donde se guardan los backups
const backupRootFolder = path.join('./backups');

// ⏳ Intervalo en minutos para backups automáticos
const backupInterval = 12 * 60;

// 📌 Definir la zona horaria (Bogotá, Colombia)
const timeZone = "America/Bogota";

// 📌 Función para obtener la fecha con formato 24h sin "a.m./p.m."
function getFormattedTimestamp() {
    const date = new Date();
    return new Intl.DateTimeFormat('en-CA', {
        timeZone,
        year: 'numeric',
        month: '2-digit',
        day: '2-digit',
        hour: '2-digit',
        minute: '2-digit',
        hour12: false // 🔹 Se fuerza el formato 24h
    }).format(date).replace(/[/,]/g, '-').replace(/:/g, '-').replace(' ', '_');
}

// 📌 Función para eliminar el backup más antiguo
function cleanOldBackups() {
    try {
        const backups = fs.readdirSync(backupRootFolder)
            .filter(folder => fs.lstatSync(path.join(backupRootFolder, folder)).isDirectory())
            .sort((a, b) => a.localeCompare(b)); // Orden ascendente (más antiguo primero)

        if (backups.length > 5) { // Mantener solo los últimos 5 backups
            const oldestBackup = path.join(backupRootFolder, backups[0]);
            fs.rmSync(oldestBackup, { recursive: true, force: true });
            console.log(`[🗑️ ] Eliminado backup antiguo: ${oldestBackup}`);
        }
    } catch (error) {
        console.error('❌ Error al limpiar backups antiguos:', error);
    }
}

// 📌 Función para crear backups
function createBackup() {
    try {
        const timestamp = getFormattedTimestamp();
        const backupFolder = path.join(backupRootFolder, timestamp);

        // 📌 Crea la carpeta si no existe
        if (!fs.existsSync(backupFolder)) {
            fs.mkdirSync(backupFolder, { recursive: true });
        }

        // 🔄 Copiar todos los archivos JSON
        const files = fs.readdirSync(sourceFolder).filter(file => file.endsWith('.json'));
        files.forEach(file => {
            const sourcePath = path.join(sourceFolder, file);
            const backupPath = path.join(backupFolder, file);
            fs.copyFileSync(sourcePath, backupPath);
        });

        console.log(`[✅ ] Backup realizado en: ${backupFolder}`);

        // 🔄 Eliminar backups antiguos después de crear uno nuevo
        cleanOldBackups();
    } catch (error) {
        console.error('❌ Error al hacer el backup:', error);
    }
}

// 📌 Función para verificar si un JSON está dañado
function isJsonValid(filePath) {
    try {
        const content = fs.readFileSync(filePath, 'utf-8');
        JSON.parse(content);
        return true;
    } catch (error) {
        return false;
    }
}

// 📌 Función para restaurar archivos dañados
function restoreCorruptedFiles() {
    try {
        const files = fs.readdirSync(sourceFolder).filter(file => file.endsWith('.json'));

        files.forEach(file => {
            const filePath = path.join(sourceFolder, file);

            if (!fs.existsSync(filePath) || !isJsonValid(filePath)) {
                console.warn(`⚠️ Archivo corrupto o faltante: ${file}`);

                const backups = fs.readdirSync(backupRootFolder)
                    .filter(folder => fs.lstatSync(path.join(backupRootFolder, folder)).isDirectory())
                    .sort((a, b) => b.localeCompare(a)); // Orden descendente (más reciente primero)

                if (backups.length > 0) {
                    const latestBackupFolder = path.join(backupRootFolder, backups[0]);
                    const backupFilePath = path.join(latestBackupFolder, file);

                    if (fs.existsSync(backupFilePath)) {
                        fs.copyFileSync(backupFilePath, filePath);
                        console.log(`✅ Archivo restaurado: ${file} desde ${latestBackupFolder}`);
                    } else {
                        console.error(`❌ No se encontró un backup válido para: ${file}`);
                    }
                } else {
                    console.error(`❌ No hay backups disponibles para restaurar: ${file}`);
                }
            }
        });
    } catch (error) {
        console.error('❌ Error al restaurar archivos corruptos:', error);
    }
}

// 🔄 Ejecuta el backup y verifica archivos cada 12 horas
setInterval(() => {
    createBackup();
    restoreCorruptedFiles();
}, backupInterval * 60 * 1000);

// 🔹 Ejecuta un backup inicial y verifica archivos al iniciar
createBackup();
restoreCorruptedFiles();
/////////////////////////////////////////////////////////////////////////////////
// Función para limpiar la carpeta
const folderPath = './media-TEMP';
async function limpiarCarpeta() {
    try {
        // Verificar si la carpeta existe
        if (await fs.pathExists(folderPath)) {
            // Eliminar todo el contenido de la carpeta
            await fs.emptyDir(folderPath);
            console.log('Carpeta media-TEMP limpiada.');
        } else {
            console.log('La carpeta media-TEMP no existe.');
        }
    } catch (err) {
        console.error('Error al limpiar la carpeta:', err);
    }
}
/////////////////////////////////////////////////////////////////////////////////
// Cargar palabras prohibidas
let badWords = [];
try {
    const data = fs.readFileSync('./database/badwords.json', 'utf8');
    const jsonData = JSON.parse(data);
    if (jsonData && Array.isArray(jsonData.palabras)) {
        badWords = jsonData.palabras;
    } else {
        console.error("⚠️ El archivo badwords.json no tiene el formato correcto.");
    }
} catch (error) {
    console.error("⚠️ Error al leer badwords.json:", error.message);
}

// 2️⃣ Verificar si el mensaje contiene palabras prohibidas
function contienePalabrasProhibidas(texto) {
    return badWords.some(palabra => texto.toLowerCase().includes(palabra));
}

// 3️⃣ Manejo de strikes en memoria
const strikesDB = {};

function registrarStrike(usuario) {
    if (!strikesDB[usuario]) {
        strikesDB[usuario] = 0;
    }
    strikesDB[usuario]++;
    return strikesDB[usuario];
}


// 📌 Función para cargar la lista de malas palabras
const badWordsFile = './database/badwords.json';
function cargarBadWords() {
    try {
        if (!fs.existsSync(badWordsFile)) {
            fs.writeFileSync(badWordsFile, JSON.stringify({ palabras: [] }, null, 2));
        }
        const data = fs.readFileSync(badWordsFile, 'utf8');
        const jsonData = JSON.parse(data);
        return jsonData.palabras || [];
    } catch (error) {
        console.error("⚠️ Error al leer badwords.json:", error.message);
        return [];
    }
}

// Verificar si el usuario es administrador
async function esAdministrador(client, chatId, usuario) {
    try {
        const metadata = await client.groupMetadata(chatId);
        const participante = metadata.participants.find(p => p.id === usuario);
        return participante && (participante.admin === 'admin' || participante.admin === 'superadmin');
    } catch (error) {
        console.error("Error obteniendo administradores:", error);
        return false;
    }
}

// 📌 Función para guardar la lista de malas palabras
function guardarBadWords(lista) {
    try {
        fs.writeFileSync(badWordsFile, JSON.stringify({ palabras: lista }, null, 2));
    } catch (error) {
        console.error("⚠️ Error al guardar badwords.json:", error.message);
    }
}

// 📌 Lista de malas palabras en memoria
//let badWords = cargarBadWords();

const saludos = "./database/saludos.json";

// ✅ Obtener la base de datos de saludos
function obtenerSaludos() {
    // Si el archivo no existe, se crea con una estructura vacía
    if (!fs.existsSync(saludos)) {
        fs.writeFileSync(saludos, JSON.stringify({ saludados: [], nosaludados: [] }, null, 2));
    }

    try {
        let data = JSON.parse(fs.readFileSync(saludos, "utf-8"));
        
        // Asegurar que siempre existan las claves necesarias
        if (!data.saludados || !Array.isArray(data.saludados)) data.saludados = [];
        if (!data.nosaludados || !Array.isArray(data.nosaludados)) data.nosaludados = [];

        return data;
    } catch (error) {
        console.error("❌ Error al leer saludos.json:", error);
        return { saludados: [], nosaludados: [] };
    }
}

// ✅ Guardar cambios en la base de datos
function guardarSaludos(data) {
    try {
        fs.writeFileSync(saludos, JSON.stringify(data, null, 2));
    } catch (error) {
        console.error("❌ Error al guardar saludos.json:", error);
    }
}

/////////////////////////////////////////////////////////////////////////////////
// Base de datos de grupos musicales
/////////////////////////////////////////////////////////////////////////////////
const musicgroupPath = './database/musicgroup.json';
// ✅ Obtener la base de datos de grupos musicales
function obtenerGruposMusicales() {
    if (!fs.existsSync(musicgroupPath)) {
        fs.writeFileSync(musicgroupPath, JSON.stringify({ activos: [], inactivos: [] }, null, 2));
    }

    try {
        let data = JSON.parse(fs.readFileSync(musicgroupPath, "utf-8"));

        // Asegurar que existan las claves necesarias
        if (!Array.isArray(data.activos)) data.activos = [];
        if (!Array.isArray(data.inactivos)) data.inactivos = [];

        return data;
    } catch (error) {
        console.error("❌ Error al leer musicgroup.json:", error);
        return { activos: [], inactivos: [] };
    }
}
// ✅ Guardar cambios en la base de datos
function guardarGruposMusicales(data) {
    try {
        fs.writeFileSync(musicgroupPath, JSON.stringify(data, null, 2));
    } catch (error) {
        console.error("❌ Error al guardar musicgroup.json:", error);
    }
}
/////////////////////////////////////////////////////////////////////////////////
// Base de datos de grupos de sismos
/////////////////////////////////////////////////////////////////////////////////
const sismosgroupPath = './database/databasesismos.json';
// ✅ Obtener la base de datos de grupos de sismos
function obtenerGruposSismos() {
    if (!fs.existsSync(sismosgroupPath)) {
        fs.writeFileSync(sismosgroupPath, JSON.stringify({ activos: [], inactivos: [] }, null, 2));
    }

    try {
        let data = JSON.parse(fs.readFileSync(sismosgroupPath, "utf-8"));

        // Asegurar que existan las claves necesarias
        if (!Array.isArray(data.activos)) data.activos = [];
        if (!Array.isArray(data.inactivos)) data.inactivos = [];

        return data;
    } catch (error) {
        console.error("❌ Error al leer databasesismos.json", error);
        return { activos: [], inactivos: [] };
    }
}
// ✅ Guardar cambios en la base de datos
function guardarGruposSismos(data) {
    try {
        fs.writeFileSync(sismosgroupPath, JSON.stringify(data, null, 2));
    } catch (error) {
        console.error("❌ Error al guardar databasesismos.json:", error);
    }
}
/////////////////////////////////////////////////////////////////////////////////
module.exports = client = async (client, m, chatUpdate, processMessage, store ) => {
    try {
        const body = (
            m.mtype === "conversation" ? m.message.conversation :
			m.mtype === "contact" ? m.message.contact :
            m.mtype === "imageMessage" ? m.message.imageMessage.caption :
            m.mtype === "videoMessage" ? m.message.videoMessage.caption :
            m.mtype === "extendedTextMessage" ? m.message.extendedTextMessage.text :
            m.mtype === "buttonsResponseMessage" ? m.message.buttonsResponseMessage.selectedButtonId :
            m.mtype === "listResponseMessage" ? m.message.listResponseMessage.singleSelectReply.selectedRowId :
            m.mtype === "templateButtonReplyMessage" ? m.message.templateButtonReplyMessage.selectedId :
            m.mtype === "interactiveResponseMessage" ? JSON.parse(m.msg.nativeFlowResponseMessage.paramsJson).id :
            m.mtype === "templateButtonReplyMessage" ? m.msg.selectedId :
            m.mtype === "messageContextInfo" ? m.message.buttonsResponseMessage?.selectedButtonId || m.message.listResponseMessage?.singleSelectReply.selectedRowId || m.text : "");
        
        const sender = m.key.fromMe ? client.user.id.split(":")[0] + "@s.whatsapp.net" || client.user.id : m.key.participant || m.key.remoteJid;
        
        const senderNumber = sender.split('@')[0];
        //const budy = (typeof m.text === 'string' ? m.text : '');
		const cmd = (m.mtype === 'conversation' && m.message.conversation) ? m.message.conversation : (m.mtype == 'imageMessage') && m.message.imageMessage.caption ? m.message.imageMessage.caption : (m.mtype == 'videoMessage') && m.message.videoMessage.caption ? m.message.videoMessage.caption : (m.mtype == 'extendedTextMessage') && m.message.extendedTextMessage.text ? m.message.extendedTextMessage.text : ''.slice(1).trim().split(/ +/).shift().toLowerCase()
		      budy = (m.mtype === 'conversation') ? m.message.conversation : (m.mtype === 'extendedTextMessage') ? m.message.extendedTextMessage.text : ''
        //const prefa = ["", "!", ".", ",", "🐤", "🗿"];
		
        const prefixRegex = /^[°zZ#$@*+,.?=''():√%!¢£¥€π¤ΠΦ_&><`™©®Δ^βα~¦|/\\©^]/;
        const prefix = prefixRegex.test(body) ? body.match(prefixRegex)[0] : '.';
        const from = m.key.remoteJid;
        const isGroup = from.endsWith("@g.us");

        const kontributor = JSON.parse(fs.readFileSync('./start/lib/database/owner.json'));
        const botNumber = await client.decodeJid(client.user.id);
        const Access = [botNumber, ...kontributor, ...global.owner].map(v => v.replace(/[^0-9]/g, '') + '@s.whatsapp.net').includes(m.sender)
        
        const isCmd = body.startsWith(global.prefix);
        const command = isCmd ? body.slice(prefix.length).trim().split(' ').shift().toLowerCase() : '';
        const command2 = body.replace(prefix, '').trim().split(/ +/).shift().toLowerCase()

        const args = body.trim().split(/ +/).slice(1);
        const pushname = m.pushName || "No Name";
		const isCreator = [botNumber, ...global.owner].map(v => v.replace(/[^0-9]/g, '') + '@s.whatsapp.net').includes(m.sender)
        const text = q = args.join(" ");
        const quoted = m.quoted ? m.quoted : m;
        const mime = (quoted.msg || quoted).mimetype || '';
        const qmsg = (quoted.msg || quoted);
        const isMedia = /image|video|sticker|audio/.test(mime);
		const owner = global.owner + '@s.whatsapp.net'; // Reemplaza con tu número de owner
		//const botNumber1 = global.bot + '@s.whatsapp.net'; // Obtiene el número del bot
		const botsya = global.bot + '@s.whatsapp.net';

        const groupMetadata = isGroup ? await client.groupMetadata(m.chat).catch((e) => {}) : "";
        //const groupOwner = isGroup ? groupMetadata.owner : "";
        const groupName = m.isGroup ? groupMetadata.subject : "";
        const participants = isGroup ? await groupMetadata.participants : "";
        const groupAdmins = isGroup ? await participants.filter((v) => v.admin !== null).map((v) => v.id) : "";
        const groupMembers = isGroup ? groupMetadata.participants : "";
        const isGroupAdmins = isGroup ? groupAdmins.includes(m.sender) : false;
        const isBotGroupAdmins = isGroup ? groupAdmins.includes(botNumber) : false;
        const isBotAdmins = isGroup ? groupAdmins.includes(botNumber) : false;
        const isAdmins = isGroup ? groupAdmins.includes(m.sender) : false;
		const isAdmins2 = isGroup ? groupAdmins.includes(kontributor) : false;
        let groupId = m.key.remoteJid;
		// Asegurar que global.prefix esté definido
		if (!global.prefix) {
			global.prefix = "!"; // Establecer un valor por defecto si no está definido
		}
		
		//const groupDBPath = "./database/groupcode.json"; // Ruta del JSON
		const globalGroup = global.group; // Grupo donde se enviará el código
		const ownerNumber = global.owner; // Número del administrador
		const EXPIRATION_TIME = 10 * 60 * 1000; // 10 minutos en milisegundos
		const MAX_INTENTOS = 5; // Máximo de intentos fallidos

		// Función para generar un código aleatorio y su hash
		function generarCodigoHash() {
			const codigo = crypto.randomBytes(4).toString("hex").toUpperCase(); // Código de 8 caracteres
			const hash = crypto.createHash("sha256").update(codigo).digest("hex"); // Hash SHA-256
			const timestamp = Date.now();
			return { codigo, hash, timestamp };
		}

		// Función para obtener datos del grupo desde el JSON
		function obtenerDatosGrupo(groupId) {
			try {
				if (fs.existsSync(groupDBPath)) {
					let groupData = JSON.parse(fs.readFileSync(groupDBPath, "utf-8"));
					return groupData[groupId] || { isAdmin: false, validated: false, hash: null, timestamp: null, name: "Grupo Desconocido", intentosFallidos: 0, bloqueado: false };
				}
			} catch (error) {
				console.error("❌ Error leyendo groupcode.json:", error);
			}
			return { isAdmin: false, validated: false, hash: null, timestamp: null, name: "Grupo Desconocido", intentosFallidos: 0, bloqueado: false };
		}

		// Función para guardar datos en el JSON
		function guardarDatosGrupo(groupId, data) {
			let groupData = {};
			if (fs.existsSync(groupDBPath)) {
				groupData = JSON.parse(fs.readFileSync(groupDBPath, "utf-8"));
			}
			groupData[groupId] = data;
			fs.writeFileSync(groupDBPath, JSON.stringify(groupData, null, 2), "utf-8");
		}

		// Función para enviar el código al grupo
		async function enviarCodigoVerificacion(client, groupName, groupId) {
			let groupData = obtenerDatosGrupo(groupId);

			// Si el grupo está bloqueado, no se genera un nuevo código
			if (groupData.bloqueado) {
				await client.sendMessage(groupId, { text: "⛔ *Este grupo ha sido bloqueado por intentos fallidos. Contacte al administrador.*" });
				return;
			}

			const { codigo, hash, timestamp } = generarCodigoHash();
			groupData.hash = hash;
			groupData.timestamp = timestamp;
			groupData.name = groupName;
			groupData.intentosFallidos = 0; // Reiniciar intentos fallidos
			guardarDatosGrupo(groupId, groupData);

			let mensajeGrupo = `📢 *Indíqueme el código de activación.*`;
			let mensajeCodigo = `🔹 *Código de Verificación para ${groupName}* 🔹\n\n📌 Código: *${codigo}*\n\n⚠ *Este código caduca en 10 minutos.*\n\n➡ Envíelo en el chat para validar el grupo.`;
			let mensajeAdmin = `🔒 *Este grupo no está validado.*\n\n📞 *Contacte al administrador:* wa.me/${ownerNumber}`;

			try {
				await client.sendMessage(groupId, { text: mensajeGrupo });
				await client.sendMessage(groupId, { text: mensajeCodigo });
				await client.sendMessage(groupId, { text: mensajeAdmin });
				console.log(`📩 Código de verificación enviado al grupo: ${groupName}`);
			} catch (error) {
				console.error("❌ Error al enviar el código de verificación:", error);
			}
		}

		// Lógica para verificar el código de validación
		if (!isCmd && body.length === 8) {
			let groupData = obtenerDatosGrupo(globalGroup);
			
			// Si el grupo está bloqueado, se informa
			if (groupData.bloqueado) {
				await client.sendMessage(globalGroup, { text: "⛔ *Este grupo ha sido bloqueado. Contacte al administrador.*" });
				return;
			}

			let hashIngresado = crypto.createHash("sha256").update(body).digest("hex");

			// Verificar si el código ha expirado
			if (Date.now() - groupData.timestamp > EXPIRATION_TIME) {
				await client.sendMessage(globalGroup, { text: "❌ *El código ha expirado. Generando uno nuevo...*" });
				enviarCodigoVerificacion(client, groupData.name, globalGroup);
				return;
			}

			// Verificar si el código es correcto
			if (groupData.hash === hashIngresado) {
				groupData.validated = true;
				groupData.intentosFallidos = 0; // Reiniciar intentos fallidos
				guardarDatosGrupo(globalGroup, groupData);
				await client.sendMessage(globalGroup, { text: "✅ *Grupo validado correctamente.*" });
			} else {
				groupData.intentosFallidos += 1;
				guardarDatosGrupo(globalGroup, groupData);

				if (groupData.intentosFallidos >= MAX_INTENTOS) {
					groupData.bloqueado = true; // Bloquea el grupo
					guardarDatosGrupo(globalGroup, groupData);
					await client.sendMessage(globalGroup, { text: "❌ *Se han alcanzado los 5 intentos fallidos. Bloqueando grupo y saliendo...*" });
					await client.groupLeave(globalGroup); // El bot se sale del grupo
				} else {
					await client.sendMessage(globalGroup, { text: `❌ *Código incorrecto. Intentos restantes: ${MAX_INTENTOS - groupData.intentosFallidos}*` });
				}
			}
		}

					// Lógica para verificar el código de validación
			if (!isCmd && body.length === 8) {
				let groupData = obtenerDatosGrupo(globalGroup);
				
				// Si el grupo está bloqueado, se informa
				if (groupData.bloqueado) {
					await client.sendMessage(globalGroup, { text: "⛔ *Este grupo ha sido bloqueado. Contacte al administrador.*" });
					return;
				}

				let hashIngresado = crypto.createHash("sha256").update(body).digest("hex");

				// Verificar si el código ha expirado
				if (Date.now() - groupData.timestamp > EXPIRATION_TIME) {
					await client.sendMessage(globalGroup, { text: "❌ *El código ha expirado. Generando uno nuevo...*" });
					enviarCodigoVerificacion(client, groupData.name, globalGroup);
					return;
				}

				// Verificar si el código es correcto
				if (groupData.hash === hashIngresado) {
					groupData.validated = true;
					groupData.intentosFallidos = 0; // Reiniciar intentos fallidos
					guardarDatosGrupo(globalGroup, groupData);
					await client.sendMessage(globalGroup, { text: "✅ *Grupo validado correctamente.*" });
				} else {
					groupData.intentosFallidos += 1;
					guardarDatosGrupo(globalGroup, groupData);

					if (groupData.intentosFallidos >= MAX_INTENTOS) {
						groupData.bloqueado = true; // Bloquea el grupo
						guardarDatosGrupo(globalGroup, groupData);
						await client.sendMessage(globalGroup, { text: "❌ *Se han alcanzado los 5 intentos fallidos. Bloqueando grupo y saliendo...*" });
						await client.groupLeave(globalGroup); // El bot se sale del grupo
					} else {
						await client.sendMessage(globalGroup, { text: `❌ *Código incorrecto. Intentos restantes: ${MAX_INTENTOS - groupData.intentosFallidos}*` });
					}
				}
			}
			
///////////////////////////////////////			
// Función para leer y obtener los datos del grupo desde el archivo JSON
function obtenerDatosGrupo(groupId) {
    // Leer el archivo JSON
    const data = fs.readFileSync(groupDBPath, 'utf8');
    const groups = JSON.parse(data);

    // Buscar los datos del grupo utilizando groupId como clave
    return groups[groupId];
}

// Comprobación antes de ejecutar comandos
if (body.startsWith(prefix)) {
    //console.log('Comando detectado:', body); // Verificar que el comando se ha detectado

    let groupData = obtenerDatosGrupo(groupId);
    //console.log('Datos del grupo:', groupData); // Verificar los datos del grupo

    // Verificar si se encontró el grupo
    if (!groupData) {
        await client.sendMessage(groupId, { text: "⛔ *Grupo no encontrado en la base de datos.*" });
        return;
    }

    // Verificar las condiciones en la base de datos (isAdmin y validated)
    if (!groupData.isAdmin || !groupData.validated) {
        if (!groupData.isAdmin) {
            await client.sendMessage(groupId, { text: "⛔ *No soy administrador. No puedo ejecutar comandos.*" });
        }
        if (!groupData.validated) {
            // Usar backticks para interpolación de variables
            await client.sendMessage(groupId, { text: `🔒 *Este grupo no está validado.*\n\n📞 *Contacte al administrador:* wa.me/${ownerNumber}` });
        }
        return;
    }

    // Si pasa todas las verificaciones, se puede ejecutar el comando
    //console.log('Ejecutando comando...'); // Verificar que estamos ejecutando el comando
    //await client.sendMessage(groupId, { text: "✅ Comando ejecutado correctamente." });
}
							
			
///////////////////////////////////////
		 if (m.messageType === "stickerMessage") {
            let sender = m.key.remoteJid; // Número del remitente
            console.log(`📩 Sticker recibido de: ${sender}`);

            // Enviar una reacción al sticker
            await client.sendMessage(sender, {
                react: { text: "✅", key: m.key } // Puedes cambiar el emoji
            });
        }
		
/*		
		//Bienvenida del Grupo
		const welcomeMessage = async (anu, client) => {
		try {
        //const chatId = anu.id;
        //const participants = anu.participants; // Lista de nuevos miembros

        // Cargar reglas desde el archivo JSON
        const reglasPath = path.join(__dirname, './database/reglas.json');
        let reglasData = JSON.parse(fs.readFileSync(reglasPath, 'utf8'));

        let reglasTexto = reglasData.reglas.map((regla, index) => `${index + 1}️⃣ ${regla}`).join("\n");

        for (let participant of participants) {
        let userName = `@${participant.split("@")[0]}`; // Extraer número sin "@s.whatsapp.net"

let welcomeText = `
👋 ¡Bienvenido al grupo, ${userName}!

📜 *Reglas del grupo:*
${reglasTexto}

🚀 ¡Esperamos que disfrutes tu estancia en el grupo!

🔹 *Si tienes dudas, contacta a un administrador.*`;

            // Enviar mensaje de bienvenida con mención
            await client.sendMessage(chatId, { text: welcomeText, mentions: [participant] });
					}
				} catch (error) {
					console.error("Error enviando mensaje de bienvenida:", error);
				}
			};
*/
////////////////////////////////////////////////////////////////////		
		// Verificar si el mensaje contiene palabras prohibidas	
		if (m.message && m.message.conversation) {
        const texto = m.message.conversation;
        if (contienePalabrasProhibidas(texto)) {
            await aplicarSancion(m, client);
        }
		}
		
		async function aplicarSancion(m, client) {
		const chatId = m.key.remoteJid;
		const autor = m.key.participant || m.key.remoteJid; // Usuario en grupo o privado

		// Verificar si es un grupo
		if (!chatId.endsWith('@g.us')) return;

		// Omitir sanción si el usuario es administrador
		if (await esAdministrador(client, chatId, autor)) {
			console.log(`🔹 ${autor} es administrador, omitiendo strike.`);
			return;
		}

		// Registrar strike
		strikesDB[autor] = (strikesDB[autor] || 0) + 1;

		let mensajeSancion = "";
		
		if (strikesDB[autor] === 1) {
			mensajeSancion = `⚠️ @${autor.split("@")[0]}, primer strike. Usa lenguaje apropiado.\n\n⚠️ Advertencia.`;
		} else if (strikesDB[autor] === 2) {
			mensajeSancion = `⚠️ @${autor.split("@")[0]}, segundo strike. Última advertencia.⚠️`;
		} else if (strikesDB[autor] >= 3) {
			mensajeSancion = `🚨 @${autor.split("@")[0]} fue expulsado por 3 strikes.`;
			await client.groupParticipantsUpdate(chatId, [autor], "remove"); // Expulsar usuario
			await client.sendMessage(autor, { text: `🚨 Fuiste expulsado del grupo por acumular 3 strikes usando malas palabras.` });
			delete strikesDB[autor]; // Reiniciar strikes tras la expulsión
			return;
		}

		await client.sendMessage(chatId, { text: mensajeSancion, mentions: [autor] });
		}
		///////////////////////////////////////////////////////////////////////////////////
		//validador de penalizacion 
		//contador de mensajes en tiempo real
		if (!m.message || !m.key || !m.participant) return;
		let now = Date.now();

		if (!userMessages.has(sender)) {
			userMessages.set(sender, []);
		}

		let timestamps = userMessages.get(sender);
		timestamps.push(now);
		timestamps = timestamps.filter(timestamp => now - timestamp < TIME_WINDOW);
		userMessages.set(sender, timestamps);

		if (timestamps.length > SPAM_LIMIT) {
			let groupMetadata = await client.groupMetadata(groupId);
			let groupName = groupMetadata.subject;

			// Si el grupo no existe en la base de datos, lo creamos correctamente
			if (!groupStrikes[groupId]) {
				groupStrikes[groupId] = {
					name: groupName,
					users: {}
				};
				console.log(`🆕 Grupo registrado: ${groupName} (${groupId})`);
			}

			// Si el usuario no está en la base de datos, lo creamos correctamente
			if (!groupStrikes[groupId].users[sender]) {
				groupStrikes[groupId].users[sender] = {
					phone: sender,
					strikes: 0
				};
				console.log(`🆕 Usuario registrado en ${groupName}: ${sender}`);
			}

			// Incrementar el strike
			groupStrikes[groupId].users[sender].strikes += 1;
			console.log(`⚠️ Strike agregado: ${sender} en ${groupName}. Total: ${groupStrikes[groupId].users[sender].strikes}`);
			guardarStrikes();

			if (groupStrikes[groupId].users[sender].strikes >= MAX_STRIKES) {
				console.log(`🚨 Eliminando usuario ${sender} de ${groupName} por 3 strikes.`);
				await client.groupParticipantsUpdate(groupId, [sender], "remove");
				await client.sendMessage(groupId, { text: `❌ Usuario eliminado por spam (${MAX_STRIKES} strikes).` });

				// Eliminar usuario de la base de datos del grupo
				delete groupStrikes[groupId].users[sender];
				guardarStrikes();
			} else {
				console.log(`🚫 Advertencia enviada a ${sender} en ${groupName}. Strike ${groupStrikes[groupId].users[sender].strikes}/3`);
				await client.sendMessage(groupId, {
					text: `🚫 No hagas spam. Llamado de atención ${groupStrikes[groupId].users[sender].strikes}/3.`
				}, { quoted: m });
			}

			userMessages.delete(sender);
		}
		
        const {
            smsg,
            fetchJson, 
            sleep,
            formatSize
            } = require('./lib/myfunction');
     
        const {
            jadibot,
	        stopjadibot,
          	listjadibot
        } = require('./jadibot')
        
        let cihuy = fs.readFileSync('./start/lib/media/SoporteyAportesBOT.jpeg')


///// creador de sticker //////
// Funciones auxiliares
function isValidImage(m) {
    return isMedia && !m.message.videoMessage && args.length === 0;
}

async function downloadMedia(m) {
    return await client.downloadAndSaveMediaMessage(m);
}

async function createAndSendSticker(media, stickerPath, chat, originalFile, messageId) {
    try {
        await ffmpeg(media)
            .input(media)
            .on('error', (err) => handleError(err, media, stickerPath, originalFile, messageId))
            .on('end', async () => {
                console.log(`[LOG] Sticker creado. Enviando...`);
                if (fs.existsSync(stickerPath)) {
                    // Enviar el sticker generado
                    await client.sendMessage(chat, { sticker: fs.readFileSync(stickerPath) });

                    // Eliminar el mensaje con el video o imagen después de la conversión
                    await deleteMessage(chat, messageId);
                    
                    // Después de enviar el sticker, eliminamos el archivo original
                    if (fs.existsSync(originalFile)) {
                        console.log(`[LOG] Eliminando archivo original: ${originalFile}`);
                        fs.unlinkSync(originalFile);
                    }
                } else {
                    console.log(`[ERROR] El archivo sticker no se generó correctamente: ${stickerPath}`);
                }
            })
            .addOutputOptions([
                '-vcodec', 'libwebp',
                '-vf', `scale='min(320,iw)':min(320,ih):force_original_aspect_ratio=decrease,fps=15,pad=320:320:-1:-1:color=white@0.0,split [a][b];[a] palettegen=reserve_transparent=on:transparency_color=ffffff [p];[b][p] paletteuse`
            ])
            .toFormat('webp')
            .save(stickerPath);
    } catch (err) {
        handleError(err, media, stickerPath, originalFile, messageId);
    }
}

function handleError(err, media, stickerPath, originalFile, messageId) {
    //console.log(`[ERROR] Conversión fallida: ${err}`);
    // Limpiar solo los archivos temporales (no el archivo original)
    cleanUpFiles([stickerPath]);
    // No limpiamos el archivo original en caso de error
    deleteMessage(media.chat, messageId);
}

function cleanUpFiles(files) {
    files.forEach(file => {
        if (fs.existsSync(file)) {
            fs.unlinkSync(file);
        } else {
            //console.log(`[WARNING] No se encontró el archivo para eliminar: ${file}`);
        }
    });
}

async function deleteMessage(chat, messageId) {
    try {
        //console.log(`[LOG] Eliminando mensaje con ID: ${messageId}`);
        await client.sendMessage(chat, { delete: { remoteJid: chat, fromMe: false, id: messageId } });
        console.log(`[LOG] Mensaje eliminado correctamente.`);
    } catch (err) {
        //console.log(`[ERROR] Error al eliminar el mensaje: ${err}`);
    }
}
///// creador de sticker //////

//////////////////////////////// Comando grupoout /////////////////////////
async function grupoOutHandler(m, client) {
    const args = m.text.trim().split(' ');

    // Leer grupos
    if (!fs.existsSync(groupDBPath)) {
        return m.reply('❌ No se encontró el archivo de grupos.');
    }

    const gruposData = JSON.parse(fs.readFileSync(groupDBPath));
    const gruposList = Object.entries(gruposData).map(([id, data]) => ({
        id,
        nombre: data.groupName || 'Nombre no definido'
    }));

    // Si no hay argumentos, mostrar la lista
    if (args.length === 1) {
        if (gruposList.length === 0) return m.reply('⚠️ No hay grupos registrados.');

        let mensaje = '📋 *Lista de grupos registrados:*\n\n';
        gruposList.forEach((g, i) => {
            mensaje += `${i + 1}. ${g.nombre}\n`;
        });
        mensaje += `\nUsa */grupoout <número>* para salir de un grupo.`;

        return m.reply(mensaje);
    }

    // Si hay argumento: salir del grupo correspondiente
    const numero = parseInt(args[1]);
    if (isNaN(numero) || numero < 1 || numero > gruposList.length) {
        return m.reply('⚠️ Número inválido. Usa `/grupoout` para ver la lista.');
    }

    const grupo = gruposList[numero - 1];

    try {
        await client.groupLeave(grupo.id);
        delete gruposData[grupo.id];
        fs.writeFileSync(groupDBPath, JSON.stringify(gruposData, null, 2));
        m.reply(`✅ El bot ha salido del grupo *${grupo.nombre}*.`);
    } catch (e) {
        console.error(e);
        m.reply('❌ Error al intentar salir del grupo.');
    }
}
///////////////////////////////////////////////////////////////////////////////

/////////////////// Contador de mensajes Modificado ///////////////////////////  
// Función para cargar los datos del contador
const DB = './database/contador.json';
const cargarContador = () => {
    if (!fs.existsSync(DB)) {
        fs.writeFileSync(DB, JSON.stringify({}, null, 2));
    }
    return JSON.parse(fs.readFileSync(DB));
};
// Función para guardar los datos del contador
const guardarContador = (contador) => {
    fs.writeFileSync(DB, JSON.stringify(contador, null, 2));
};
// Función para registrar usuarios en la base de datos
const registrarUsuariosGrupo = (groupJid, participantes) => {
    let contador = cargarContador();
    if (!contador[groupJid]) {
        contador[groupJid] = {};
    }

    participantes.forEach(usuario => {
        let userJid = usuario.endsWith("@s.whatsapp.net") ? usuario : usuario + "@s.whatsapp.net";
        if (!contador[groupJid][userJid]) {
            contador[groupJid][userJid] = {
                mensajes: 0,
                ultimaHora: null
            };
        }
    });

    guardarContador(contador);
};
// Verificar si el mensaje es válido
if (m.message) {
    console.log('\x1b[30m--------------------\x1b[0m');
    console.log(chalk.bgHex("#e74c3c").bold(`▢ Nuevo Mensaje`));
    // Extraer el cuerpo del mensaje
    const mensajeTexto = m.body || m.mtype;
    const senderJid = m.sender.endsWith("@s.whatsapp.net") ? m.sender : m.sender + "@s.whatsapp.net";
    // Verificar si el mensaje proviene de un canal
    const isChannel = m.chat.endsWith("@broadcast");
    
    if (isChannel) {
        console.log(
            chalk.bgHex("#FFA500").black(
                `   ⌬ 📢 Mensaje de Canal \n` +
                `   ⌬ Canal ID: ${m.chat} \n` +
                `   ⌬ Fecha: ${new Date().toLocaleString()} \n` +
                `   ⌬ Mensaje: ${mensajeTexto}`
            )
        );

    } else if (m.isGroup) {
        console.log(
            chalk.bgHex("#00FF00").black(
                `   ⌬ 📣 Mensaje en Grupo \n` +
                `   ⌬ GrupoJid: ${m.chat} \n` +
                `   ⌬ Remitente: ${m.sender} \n` +
                `   ⌬ Mensaje: ${mensajeTexto}`
            )
        );

        // Lista de participantes del grupo
        let participantes = m.participants || [];

        // Convertir los participantes a formato correcto
        participantes = participantes.map(p => p.endsWith("@s.whatsapp.net") ? p : p + "@s.whatsapp.net");

        //console.log("Participantes del grupo:", participantes);

        // Registrar usuarios en la base de datos si no existen
        registrarUsuariosGrupo(m.chat, participantes);

        // Cargar el contador actualizado
        let contador = cargarContador();

        // Asegurar que el grupo y el usuario existen en la base de datos
        if (!contador[m.chat]) {
            contador[m.chat] = {};
        }
        if (!contador[m.chat][senderJid]) {
            contador[m.chat][senderJid] = { mensajes: 0, ultimaHora: null };
        }

        // Incrementar el contador del usuario que envió el mensaje
        contador[m.chat][senderJid].mensajes++;
        contador[m.chat][senderJid].ultimaHora = new Date().toLocaleString();

        //console.log("Estado del contador actualizado:", contador);

        // Guardar el contador actualizado
        guardarContador(contador);

    } else {
        console.log(
            chalk.bgHex("#1E90FF").black(
                `   ⌬ 💬 Mensaje Privado \n` +
                `   ⌬ Remitente: ${m.sender} \n` +
                `   ⌬ Fecha: ${new Date().toLocaleString()} \n` +
                `   ⌬ Mensaje: ${mensajeTexto}`
            )
        );
    }
    console.log();
}
///////////////////////////////////////////////////////////

async function limpiarGrupo(m, client) {
    if (!m.isGroup) {
        return reply("Este comando solo se puede usar en grupos.");
    }

    const chatId = m.chat;
    const grupo = await client.groupMetadata(chatId);
    const participantes = grupo.participants.map(p => p.id);
    
    let contador = cargarContador();

    if (!contador[chatId]) {
        contador[chatId] = {};
    }

    let usuariosParaEliminar = participantes.filter(user => 
        !contador[chatId][user] || contador[chatId][user].mensajes === 0
    );

    if (usuariosParaEliminar.length === 0) {
        return reply("No hay usuarios inactivos para eliminar.");
    }

    for (let i = 0; i < usuariosParaEliminar.length; i++) {
        let user = usuariosParaEliminar[i];

        console.log(chalk.red(`Expulsando a: ${user}`));

        try {
            await client.groupParticipantsUpdate(chatId, [user], "remove");
            await new Promise(resolve => setTimeout(resolve, 5000)); // Espera 5 segundos antes de eliminar el siguiente usuario
        } catch (error) {
            console.error(`Error al eliminar a ${user}:`, error);
        }
    }

    reply("Limpieza de usuarios inactivos completada.");
}

///////////////////////////////////////////////////////////////////

        const reaction = async (jidss, emoji) => {
            client.sendMessage(jidss, {
                react: {
                    text: emoji,
                    key: m.key 
                } 
            })
        };


        if (budy.match(`drive.google.com`) ||
		budy.match(`terabox.com`) ||
		budy.match(`1024terabox.com`) ||		
		budy.match(`teraboxapp.com`) ||
		budy.match(`terabox.app`) || 
		budy.match(`mega.nz`) || 
		budy.match(`my.sharepoint.com`)) {
		m.reply(`══✪〘 *🤖 Mensaje de BOT* 〙✪══\n➲ *Mensaje Automatico:*\n\n *¡Aprovechen los enlaces, recuerden que algunos seran desactivados sin previo aviso.!*\n\n*Mensaje de BOT*`);
		}
		
		// Mensaje de Udemy
        if (budy.match(`udemy.com`)) {
		m.reply(`══✪〘 *🤖 Mensaje de BOT* 〙✪══\n➲ *Mensaje Automatico:*\n*¡Aprovechen los enlaces, recuerden que algunos cursos no son gratis, checa antes y nos confirma.!*\n\n*Si esta activo un*   👍🏻\n*En caso contrario* 😢\n\n*Gracias*`);
		}


async function getBuffer(url) {
    const res = await axios.get(url, { responseType: 'arraybuffer' });
    return Buffer.from(res.data);
}

        
async function loading() {
    return reply("Tiempo de carga...");
}
        
        async function reply(text) {
            client.sendMessage(m.chat, {
                text: text,
                contextInfo: {
                    mentionedJid: [sender],
                    externalAdReply: {
                        title: "• Soporte y Aportes",
                        body: "• Soporte y Aportes BOT",
                        thumbnailUrl: "https://i.ibb.co/twxYmjf8/Soportey-Aportes-BOT.jpg",
                        sourceUrl: '',
                        renderLargerThumbnail: false,
                    }
                }
            }, { quoted: m })
        }
        
        const pluginsLoader = async (directory) => {
            let plugins = [];
            const folders = fs.readdirSync(directory);
            folders.forEach(file => {
                const filePath = path.join(directory, file);
                if (filePath.endsWith(".js")) {
                    try {
                        const resolvedPath = require.resolve(filePath);
                        if (require.cache[resolvedPath]) {
                            delete require.cache[resolvedPath];
                        }
                        const plugin = require(filePath);
                        plugins.push(plugin);
                    } catch (error) {
                        console.log(`${filePath}:`, error);
                    }
                }
            });
            return plugins;
        };

        const pluginsDisable = true;
        const plugins = await pluginsLoader(path.resolve(__dirname, "../command"));
        const plug = { client, prefix, command, reply, text, Access, reaction, isGroup: m.isGroup, isPrivate: !m.isGroup, pushname, mime, quoted };
        /*
        for (let plugin of plugins) {
            if (plugin.command.find(e => e == command.toLowerCase())) {
                if (plugin.owner && !Access) {
                    return reply(mess.owner);
                }
                
                if (plugin.group && !plug.isGroup) {
                    return m.reply(mess.group);
                }
                
                if (plugin.private && !plug.isPrivate) {
                    return m.reply(mess.private);
                }

                if (typeof plugin !== "function") return;
                await plugin(m, plug);
            }
        }*/
        
        for (let plugin of plugins) {
            // Asegúrate de que 'plugin.command' esté definido y sea un array
            if (plugin.command && Array.isArray(plugin.command) && plugin.command.find(e => e == command.toLowerCase())) {
                if (plugin.owner && !Access) {
                    return reply(mess.owner);
                }
        
                if (plugin.group && !plug.isGroup) {
                    return m.reply(mess.group);
                }
        
                if (plugin.private && !plug.isPrivate) {
                    return m.reply(mess.private);
                }
        
                if (typeof plugin !== "function") return;
                await plugin(m, plug);
            }
        }
        
        if (!pluginsDisable) return;  
		
//////////////////////////////////////cronjobs para ejecutarse ////////////////////////////
        // Ejecutar la función cada 5 minutos
//////////////////////////////////////////////////////////////////   Agregado el 20/03/2025
// Función para cargar la lista de grupos
const pathCount = './database/listagrupos.json';
// Función para cargar la lista de grupos
const loadListaGrupos = () => {
    if (!fs.existsSync(pathCount)) {
        fs.writeFileSync(pathCount, JSON.stringify({}, null, 2));
    }
    return JSON.parse(fs.readFileSync(pathCount, 'utf8'));
};

// Función para actualizar la lista de grupos y usuarios con mensajes = 0
async function obtenerGruposYUsuarios(client) {
    let usuariosGrupos = {};

    // Leer datos existentes del archivo (si existen)
    let dataExistente = {};
    if (fs.existsSync(pathCount)) {
        dataExistente = JSON.parse(fs.readFileSync(pathCount, 'utf8'));
    }

    // Obtener todos los chats (grupos)
    const chats = await client.chats.all();  // Obtener todos los chats

    for (let chat of chats) {
        if (chat.isGroup) {
            const groupMetadata = await client.groupMetadata(chat.id);
            const groupId = chat.id;
            usuariosGrupos[groupId] = dataExistente[groupId] || {};  // Conservar datos previos si existen

            // Obtener todos los miembros del grupo
            for (let participant of groupMetadata.participants) {
                const userId = participant.id;

                // Inicializamos el objeto de cada usuario con mensajes y última hora
                if (!usuariosGrupos[groupId][userId]) {
                    usuariosGrupos[groupId][userId] = {
                        "mensajes": 0,
                        "ultimaHora": "N/A"
                    };
                }
            }
        }
    }

    // Guardar los datos en el archivo JSON
    fs.writeFileSync(filePath, JSON.stringify(usuariosGrupos, null, 2));
    console.log("Datos de grupos y usuarios guardados.");
}

//funcion antilink
        if (budy.match(`chat.whatsapp.com`)) {
        m.reply(`「 ANTI LINK 」\n\nSe te detectó enviando un enlace de grupo, lo sentimos, serás expulsado. !`)
        if (!isBotAdmins) return m.reply(`Eh, el bot no es un administrador. T_T`)
        let gclink = (`https://chat.whatsapp.com/`+await client.groupInviteCode(m.chat))
        let isLinkThisGc = new RegExp(gclink, 'i')
        let isgclink = isLinkThisGc.test(m.text)
        if (isgclink) return m.reply(`Eh, lo siento, no funcionó, porque enviaste este enlace de grupo.`)
        if (isAdmins) return m.reply(`Perdonaos tu eres un administrador.`)
        if (isOwner) return m.reply(`Ehh lo siento eres mi dueño.`)
        client.groupParticipantsUpdate(m.chat, [m.sender], 'remove')
		}

// Función para leer permisos desde el archivo JSON y asegurar estructura válida
function obtenerPermisos() {
    if (!fs.existsSync(permisoPath)) {
        fs.writeFileSync(permisoPath, JSON.stringify({ permitidos: [], denegados: [] }, null, 2));
    }

    let permisos = JSON.parse(fs.readFileSync(permisoPath, "utf-8"));

    // Asegurar que siempre existan los arrays permitidos y denegados
    if (!permisos.permitidos) permisos.permitidos = [];
    if (!permisos.denegados) permisos.denegados = [];

    return permisos;
}

// Función para guardar permisos en el archivo JSON
function guardarPermisos(permisos) {
    fs.writeFileSync(permisoPath, JSON.stringify(permisos, null, 2));
}

async function acortarURL(urlLarga) {
    try {
        const res = await axios.get(`https://tinyurl.com/api-create.php?url=${encodeURIComponent(urlLarga)}`);
        return res.data;
    } catch (e) {
        console.error('[URL SHORTENER] Error al acortar la URL:', e);
        return urlLarga; // Retorna la original si falla
    }
}
//////////////////////////////////////////////////////////////////	
switch (command) {
//Limpieza de grupo
case 'limpiezagrupo':{
        limpiarGrupo(m, client);
	}
break;
//Usuarios activos en el whatsapp
case 'onlineusers': 
case 'usuariosactivos': {
    await reaction(m.chat, '⏳');

    let id = args && /\d+\-\d+@g.us/.test(args[0]) ? args[0] : m.chat;
    let online = [...Object.keys(store.presences[id]), botNumber];
    const messageText = '*Miembros Activos* :\n\n' + online.map(v => '🟢 @' + v.replace(/@.+/, '')).join('\n');

    client.sendText(m.chat, messageText, m, { mentions: online }).then(async (sentMessage) => {
        try {
            await new Promise(resolve => setTimeout(resolve, 15000)); // Espera 15 segundos
            await client.sendMessage(m.chat, { delete: m.key }); // Elimina el mensaje del usuario
            await client.sendMessage(m.chat, { delete: sentMessage.key }); // Elimina el mensaje de respuesta
        } catch (err) {
            console.error("❌ Error eliminando mensajes:", err);
        }
    });
}
break;
case 'mscloud': {
    if (!text) return client.sendMessage(from, { text: '❌ Debes proporcionar un término de búsqueda. -A o -C' });

    await reaction(m.chat, '⏳');
    const axios = require('axios');
    const fs = require('fs');
    const path = require('path');

    const tenantId = "de8254a7-bdd7-41d5-a352-28c86cdad963";
    const clientId = "58e812a7-466b-4a99-a5b3-0b196a280776";
    const clientSecret = "XGk8Q~ZgocwxmJR1_TUpgMwspiVHU59pzqunJb.R";
    const driveId = "b!nrq1BXKy3UCj635Kcgv6mOwHz-SRMxBBt0WVFZgJ45WjNtg_wtI1TJqE_9vxHwHT";

    async function getAccessToken() {
        try {
            const response = await axios.post(`https://login.microsoftonline.com/${tenantId}/oauth2/v2.0/token`, new URLSearchParams({
                grant_type: "client_credentials",
                client_id: clientId,
                client_secret: clientSecret,
                scope: "https://graph.microsoft.com/.default",
            }));
            return response.data.access_token;
        } catch (error) {
            console.error("❌ Error obteniendo token:", error.response?.data || error.message);
            return null;
        }
    }

    async function searchOneDriveFiles(searchTerm, searchType) {
        const accessToken = await getAccessToken();
        if (!accessToken) return [];

        const url = `https://graph.microsoft.com/v1.0/drives/${driveId}/root/search(q='${searchTerm}')`;

        try {
            const response = await axios.get(url, {
                headers: { Authorization: `Bearer ${accessToken}` },
            });

            let items = response.data.value.filter(item =>
                (searchType === "-C" && item.folder && item.name.toLowerCase().includes(searchTerm.toLowerCase())) ||
                (searchType === "-A" && !item.folder && item.name.toLowerCase().includes(searchTerm.toLowerCase()))
            );

            return items;
        } catch (error) {
            console.error("❌ Error al buscar archivos en OneDrive:", error.response?.data || error.message);
            return [];
        }
    }

    (async () => {
        const args = text.split(" ");
        const searchType = args[0];
        const searchTerm = args.slice(1).join(" ");

        if (!["-A", "-C"].includes(searchType)) {
            return client.sendMessage(from, { text: '⚠️ Debes indicar "-A" para archivos o "-C" para carpetas.\nEjemplo: /mscloud -A documento' });
        }

        console.log(`🔍 Buscando en OneDrive: ${searchTerm} (${searchType})`);
        const results = await searchOneDriveFiles(searchTerm, searchType);

        let responseMessage = "";
        let storedResults = [];

        if (results.length > 0) {
            responseMessage = `🔍 *Resultados de búsqueda (${searchType}):* \n\n`;

            results.forEach(item => {
                let parentPath = item.parentReference?.path ? item.parentReference.path.replace("/drive/root:", "") : "/";
                let fullPath = `${parentPath}/${item.name}`.replace("//", "/");

                let matchedPath = "";
                let match = item.webUrl.match(/\/Documents\/(.+)/);
                if (match) {
                    matchedPath = match[1];
                }

                if (searchType === "-C") {
                    responseMessage += `📂 *${item.name}*\n📁 Ruta: ${decodeURIComponent(matchedPath || fullPath)}\n\n`;
                } else {
                    let fileName = item.name.replace(/\.[^/.]+$/, "");
                    responseMessage += `📄 *${fileName}*\n📁 Ubicación: ${decodeURIComponent(matchedPath || fullPath)}\n\n`;
                }

                storedResults.push({
                    name: item.name,
                    path: decodeURIComponent(matchedPath || fullPath),
                    type: searchType === "-C" ? "folder" : "file",
                    webUrl: item.webUrl
                });
            });
        } else {
            responseMessage = `⚠️ No se encontraron resultados con el nombre "${searchTerm}".`;
        }

        client.sendMessage(from, { text: responseMessage }).then(async (sentMessage) => {
            try {
                await new Promise(resolve => setTimeout(resolve, 60000)); // Espera 1 minuto
                await client.sendMessage(from, { delete: m.key }); // Elimina el comando enviado por el usuario
                await client.sendMessage(from, { delete: sentMessage.key }); // Elimina el mensaje de respuesta
            } catch (err) {
                console.error("❌ Error eliminando mensajes:", err);
            }
        });

        const databaseDir = path.resolve('./database');
        if (!fs.existsSync(databaseDir)) {
            fs.mkdirSync(databaseDir, { recursive: true });
        }

        const databasePath = path.join(databaseDir, 'cloud.json');

        let databaseData = [];
        if (fs.existsSync(databasePath)) {
            try {
                databaseData = JSON.parse(fs.readFileSync(databasePath, "utf-8"));
            } catch (err) {
                console.error("❌ Error al leer el archivo JSON:", err);
            }
        }

        databaseData.push(...storedResults);

        try {
            fs.writeFileSync(databasePath, JSON.stringify(databaseData, null, 2));
            console.log("✅ Datos guardados en cloud.json");
        } catch (err) {
            console.error("❌ Error al guardar en cloud.json:", err);
        }
    })();
}
break;
//contador global indica toda la info de los grupos y chats
case 'contadorglobal': {
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    console.log("Ejecutando comando 'contadorglobal'");
    if (!m.isGroup) return reply("Este comando solo funciona en grupos.");
    await reaction(m.chat, '⏳');
    console.log("Cargando contador...");
    let contador = cargarContador();
    
    if (Object.keys(contador).length === 0) {
        console.log("No hay registros de actividad");
        return reply("No hay registros de actividad.");
    }
    
    let rankingGrupos = {};
    let rankingPrivados = {};
    let nombresGrupos = {};
    
    console.log("Procesando chats...");
    for (let chat in contador) {
        for (let usuario in contador[chat]) {
            let totalMensajes = contador[chat][usuario].mensajes || 0;
            let usuarioID = usuario.replace(/@s\.whatsapp\.net|@g\.us|@whatsapp\.com/g, ''); // Eliminar dominios

            if (chat.includes("@g.us")) {
                console.log(`Obteniendo metadata para el grupo ${chat}`);
                let metadata = await client.groupMetadata(chat).catch(err => {
                    console.error(`Error obteniendo metadata para ${chat}:`, err);
                    return null;
                });
                let nombreGrupo = metadata ? metadata.subject : chat;
                nombresGrupos[chat] = nombreGrupo;
                
                if (!rankingGrupos[chat]) rankingGrupos[chat] = {};
                if (!rankingGrupos[chat][usuarioID]) rankingGrupos[chat][usuarioID] = 0;
                rankingGrupos[chat][usuarioID] += totalMensajes;
                
                await new Promise(r => setTimeout(r, 1000)); // Evitar rate limit
            } else {
                if (!rankingPrivados[usuarioID]) rankingPrivados[usuarioID] = 0;
                rankingPrivados[usuarioID] += totalMensajes;
            }
        }
    }
    
    console.log("Construyendo mensaje de respuesta...");
    let mensaje = "🌍 *Ranking Global de Mensajes* 🌍\n\n";
    mensaje += "🔹 *Ranking de Grupos* 🔹\n";
    
    if (Object.keys(rankingGrupos).length > 0) {
        for (let chat in rankingGrupos) {
            mensaje += `🏠 *Grupo:* ${nombresGrupos[chat]}\n`;
            let usuariosGrupo = Object.entries(rankingGrupos[chat])
                .map(([numero, mensajes]) => ({ numero, mensajes }))
                .sort((a, b) => b.mensajes - a.mensajes);
            
            usuariosGrupo.forEach((usuario, index) => {
                mensaje += `  🏅 *#${index + 1}* - ${usuario.numero}\n  📨 *Mensajes:* ${usuario.mensajes}\n`;
            });
            mensaje += "\n";
        }
    } else {
        mensaje += "📭 No hay actividad en grupos.\n\n";
    }
    
    mensaje += "🔸 *Ranking de Chats Privados* 🔸\n";
    let rankingP = Object.entries(rankingPrivados)
        .map(([numero, mensajes]) => ({ numero, mensajes }))
        .sort((a, b) => b.mensajes - a.mensajes);
    
    if (rankingP.length > 0) {
        rankingP.forEach((usuario, index) => {
            mensaje += `🏅 *#${index + 1}* - ${usuario.numero}\n📨 *Mensajes:* ${usuario.mensajes}\n`;
        });
    } else {
        mensaje += "📭 No hay actividad en chats privados.\n";
    }
    
    console.log("Enviando respuesta...");
    reply(mensaje);
}
break;
//Contador general del grupo
case 'contadorgeneral': {
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    if (!m.isGroup) return reply("Este comando solo funciona en grupos.");
    
    // Cargar la base de datos
    await reaction(m.chat, '✅');
    let contador = cargarContador();

    // Verificar si hay registros en el grupo
    if (!contador[m.chat] || Object.keys(contador[m.chat]).length === 0) {
        return reply("No hay registros de actividad en este grupo.");
    }

    // Obtener los usuarios del grupo con sus conteos de mensajes
    let ranking = Object.entries(contador[m.chat])
        .map(([numero, datos]) => ({
            numero: numero.replace('@s.whatsapp.net', ''), // Eliminar @s.whatsapp.net
            mensajes: datos.mensajes || 0
        }))
        .sort((a, b) => b.mensajes - a.mensajes); // Ordenar de mayor a menor

    // Construir el mensaje de respuesta
    let mensaje = "*Aviso:*\n*ESTARA VISIBLE POR 30 SEGUNDOS*\n\n📊 *Ranking de Mensajes en el Grupo* 📊\n\n";
    ranking.forEach((usuario, index) => {
        mensaje += `🏅 *#${index + 1}* - ${usuario.numero}\n📨 *Mensajes:* ${usuario.mensajes}\n`;
    });

    try {
        // Enviar el mensaje y almacenar el resultado
        global.mensajeContadorGeneral = await client.sendMessage(m.chat, { text: mensaje });

        // Temporizador para eliminar el mensaje después de 30 segundos
        if (global.mensajeContadorGeneral) {
            setTimeout(async () => {
                try {
                    await client.sendMessage(m.chat, { delete: global.mensajeContadorGeneral.key });
                    await client.sendMessage(m.chat, { delete: m.key });
                    console.log("✅ Mensaje eliminado correctamente.");
                } catch (error) {
                    console.error("❌ Error al eliminar el mensaje:", error);
                }
            }, 30000);
        } else {
            console.error("❌ El mensaje no se envió correctamente.");
        }
    } catch (error) {
        console.error("❌ Error al enviar el mensaje:", error);
        reply("Hubo un problema al enviar el mensaje.");
    }
}
break;
//contador de mensajes unitario
case 'micontador': {
    if (!m.isGroup) return reply("Este comando solo funciona en grupos.");
    await reaction(m.chat, '✅');

    // Obtener el número del usuario sin @s.whatsapp.net
    let senderNumber = m.sender.replace('@s.whatsapp.net', '');

    // Cargar la base de datos del contador
    let contador = cargarContador();

    // Validaciones del grupo y usuario
    if (!contador[m.chat]) return reply("No hay registros de actividad en este grupo.");
    
    let userId = `${senderNumber}@s.whatsapp.net`;
    if (!contador[m.chat][userId]) return reply("No tienes mensajes registrados en este grupo.");

    // Datos del usuario
    let { mensajes, ultimaHora } = contador[m.chat][userId];
    let mensaje = `📊 *Conteo de Mensajes en este Grupo* 📊\n\n` +
                  `👤 *Usuario:* ${senderNumber}\n` +
                  `📨 *Mensajes enviados:* ${mensajes}\n` +
                  `⏳ *Último mensaje:* ${ultimaHora || "No registrado"}`;

    try {
        // Enviar mensaje
        global.mensajeMicontador = await client.sendMessage(m.chat, { text: mensaje });

        // Si se envió correctamente, esperar 15 segundos y eliminar
        if (global.mensajeMicontador) {
            setTimeout(async () => {
                try {
                    await client.sendMessage(m.chat, { delete: global.mensajeMicontador.key });
                    await client.sendMessage(m.chat, { delete: m.key });
                    console.log("✅ Mensaje eliminado correctamente.");
                } catch (error) {
                    console.error("❌ Error al eliminar el mensaje:", error);
                }
            }, 15000);
        } else {
            console.error("❌ El mensaje no se envió correctamente.");
        }
    } catch (error) {
        console.error("❌ Error al enviar el mensaje:", error);
        reply("Hubo un problema al enviar el mensaje.");
    }
}
break;
case 'menu': {
    await client.sendMessage(m.chat, { react: { text: '📜', key: m.key } });

    // Verifica si es administrador
    const groupMetadata = m.isGroup ? await client.groupMetadata(m.chat) : {};
    const isAdmin = m.isGroup ? groupMetadata.participants.find(p => p.id === m.sender)?.admin !== null : false;

    // Texto del menú
    let textoMenu = `
> *Comandos de Videos*  

   ⨳ ${prefix}yt (url o nombre de canción o video)
   ⨳ ${prefix}yt2 (url o nombre de canción o video)
   ⨳ ${prefix}ytext (url o nombre de canción o video)
   ⨳ ${prefix}igdl (url del video)
   ⨳ ${prefix}fbdl (url del video)
   ⨳ ${prefix}tiktok (url del video)

> *Comandos de Grupo*

   ⨳ ${prefix}s (sticker)
   ⨳ ${prefix}onlineusers (usuarios activos)
   ⨳ ${prefix}waifu (Envia un Waifu)
   ⨳ ${prefix}neko (Envia un Neko)
   ⨳ ${prefix}micontador (Mensajes de usuario)
   ⨳ ${prefix}numerosuerte  (Número de la suerte)
   ⨳ ${prefix}cualesmisuerte (Mensaje de suerte)
   ⨳ ${prefix}linkgrupo (Link del grupo)
   ⨳ ${prefix}cafe (Envia un cafe)
   ⨳ ${prefix}pinterest (Imagen a buscar)
   ⨳ ${prefix}reglas (Reglas del grupo)

> *Comandos de Herramientas*  

   ⨳ ${prefix}mscloud (Buscador de Cloud)
   ⨳ ${prefix}optimizacion  (Optimizacion de Windows)
   ⨳ ${prefix}officeinstall  (Instalacion de Office)
   ⨳ ${prefix}cloud (Link del Cloud)
   ⨳ ${prefix}remoto (Enlaces a los Remotos)

> *Comandos de Autochat*  

   ⨳ ${prefix}autochatia (Proximamente)
`;

    if (isAdmin) {
        textoMenu += `

> *Comandos de Administrador* 
	
   ⨳ ${prefix}contadorgeneral (Mensajes de usuario en grupo)
   ⨳ ${prefix}contadorglobal (Contador de todos los grupos)
   ⨳ ${prefix}public (Grupo Publico) 
   ⨳ ${prefix}self (Grupo Privado)
   ⨳ ${prefix}bcgroup (Enviar mensaje a todos los grupos)
   ⨳ ${prefix}infoadmin (Informacion del Admin)
   ⨳ ${prefix}infobot (Informativo del Bot)
   ⨳ ${prefix}entrar (Añadir usuario al grupo)
   ⨳ ${prefix}salir (Salir del grupo)
   ⨳ ${prefix}promover (Subir admin)
   ⨳ ${prefix}demotar (Bajar admin)
   ⨳ ${prefix}eliminar (Eliminar usuario individual)
   ⨳ ${prefix}tagall (Mencionar a todos)
   ⨳ ${prefix}setnombregrupo (Nombre del grupo)
   ⨳ ${prefix}setdescgrupo (Descripcion del grupo)
   ⨳ ${prefix}setimagegroup (Imagen del grupo)
   ⨳ ${prefix}setnombrebot (Nombre del Bot)
   ⨳ ${prefix}setdescbot (Descripcion del Bot)
   ⨳ ${prefix}setimagebot (Imagen del Bot)
   ⨳ ${prefix}addbadword (Agregar palabra)
   ⨳ ${prefix}delbadword (Eliminar palabra)
   ⨳ ${prefix}listbadword (ver lista de palabras)
   ⨳ ${prefix}autodelgrupo (Eliminar usuarios automaticos)
   ⨳ ${prefix}updatelist (Comparador de listas para grupos)
   ⨳ ${prefix}verificarlistas (verifica usuarios para eliminar de grupos)
   ⨳ ${prefix}añadirpermisos (Especiales)
   ⨳ ${prefix}quitarpermisos (Especiales)
   ⨳ ${prefix}listarpermisos (Especiales)
   ⨳ ${prefix}añadirsaludos (Activar Saludos en el grupo)
   ⨳ ${prefix}eliminarsaludos (Eliminar Saludos en el grupo)
   ⨳ ${prefix}listasaludados (Ver lista de saludos)
   ⨳ ${prefix}grupolistout (Eliminar Bot de algun grupo)
   ⨳ ${prefix}activarautomusica (Activar automusica)
   ⨳ ${prefix}desactivarautomusica (Desactivar automusica)
   ⨳ ${prefix}listaautomusica (Lista de automusica en grupos)

`;
    }

    global.mensajeMenu = await client.sendMessage(m.chat, {
        document: { url: 'https://i.ibb.co/twxYmjf8/Soportey-Aportes-BOT.jpg' },
        jpegThumbnail: fs.readFileSync("./start/lib/media/th.jpeg"),
        caption: textoMenu,
        contextInfo: {
            isForwarded: false,
            forwardedNewsletterMessageInfo: {
                serverMessageId: 2
            },
            externalAdReply: {
                title: "Soporte y Aportes Globex",
                body: 'Comunidad para la comunidad',
                thumbnailUrl: "https://i.ibb.co/twxYmjf8/Soportey-Aportes-BOT.jpg",
                sourceUrl: ``,
                mediaType: 1,
                renderLargerThumbnail: false
            }
        },
        buttons: [
            { buttonId: `${prefix}donacion`, buttonText: { displayText: `Donación 💱` }, type: 1 },
            { buttonId: `${prefix}owner`, buttonText: { displayText: `Contacte con Administrador 🦅` }, type: 1 },
            { buttonId: `${prefix}version`, buttonText: { displayText: `Version del Bot 🤖` }, type: 1 }
        ],
        headerType: 6,
        viewOnce: true
    });

    setTimeout(async () => {
        if (global.mensajeMenu) {
            await client.sendMessage(m.chat, { delete: global.mensajeMenu.key });
        }
        await client.sendMessage(m.chat, { delete: m.key });
    }, 60000);
}
break;
//Optimizacion
case 'optimizacion':
case 'optimización': {
    await client.sendMessage(m.chat, { react: { text: '🖥️', key: m.key } });

    // Enviar el mensaje inicial y guardar referencia
    global.mensajeOptimizacion = await client.sendMessage(from, {
        image: { url: `https://i.ibb.co/Gvxy303d/imagen-1729185594463.jpg` },
        caption: `Para usar el instalador debes usarlo con la siguiente línea de Powershell.\nLink de uso para powershell:\n\nirm https://cutt.ly/NewOptimize | iex\n\nCon la tecla Windows + X, buscas el apartado Powershell (Administrador)\nLuego copias y pegas y luego presionas enter para ejecutar el script.`
    }).catch(err => {
        console.error("Error al enviar el mensaje:", err);
    });

    // Esperar 15 segundos antes de eliminar el mensaje
    setTimeout(async () => {
        if (global.mensajeOptimizacion) {
            await client.sendMessage(m.chat, { delete: global.mensajeOptimizacion.key });
        }
        await client.sendMessage(m.chat, { delete: m.key });
    }, 15000);
}
break;
case 'officeinstall': {
    await client.sendMessage(m.chat, { react: { text: '🖥️', key: m.key } });

    client.sendMessage(from, {
        image: { url: `https://i.ibb.co/yF10fk3P/imagen-1729185748963.jpg` },
        caption: `Para usar el instalador debes usarlo con la siguiente línea de PowerShell.\n*Código de uso para PowerShell:*\n*Recuerde copiar todo*\n\nirm https://cutt.ly/OfficeOnlineInstall | iex\n\nCon la tecla Windows + X, busca el apartado PowerShell (Administrador).\nLuego copias, pegas y presionas enter para ejecutar el script.`
    }).then(async (sentMessage) => {
        try {
            await new Promise(resolve => setTimeout(resolve, 15000)); // Espera 15 segundos
            await client.sendMessage(m.chat, { delete: m.key }); // Elimina el mensaje del usuario
            await client.sendMessage(m.chat, { delete: sentMessage.key }); // Elimina el mensaje de respuesta
        } catch (err) {
            console.error("❌ Error eliminando mensajes:", err);
        }
    }).catch(err => {
        console.error("❌ Error al enviar el mensaje:", err);
    });
}
break;
//CLOUD DIRECTORIO
case 'cloud': {
    try {
        await client.sendMessage(m.chat, { react: { text: '☁️', key: m.key } });

        // Enviar mensaje inicial y guardar referencia
        global.mensajeBotCloud = await client.sendMessage(m.chat, {
            document: { url: 'https://blog.tecnetone.com/hubfs/drive.png' },
            jpegThumbnail: fs.readFileSync("./start/lib/media/th.jpeg"),
            caption: "Tienes 30 segundos para usar este comando\n\n*Aquí se encuentran los accesos al cloud*\n\n*Subida de archivos*🖥️⬆️☁️\n\n*Bajada de Archivos, recuerde la contraseña de acceso está abajo*🖥️⬇️☁️\n\n*Contraseña del Cloud*",
            contextInfo: {
                isForwarded: false,
                externalAdReply: {
                    title: "Cloud S&A",
                    body: 'Nube para la comunidad',
                    thumbnailUrl: "https://blog.tecnetone.com/hubfs/drive.png",
                    sourceUrl: ``,
                    mediaType: 1,
                    renderLargerThumbnail: false
                }
            },
            buttons: [
                { buttonId: `${prefix}upload`, buttonText: { displayText: `Upload Files 🖥️⬆️☁️` }, type: 1 },
                { buttonId: `${prefix}download`, buttonText: { displayText: `Nube Privada 🖥️⬇️☁️` }, type: 1 }
                //{ buttonId: `${prefix}passwordshared`, buttonText: { displayText: `Contraseña 🔐☁️` }, type: 1 }
            ],
            headerType: 6,
            viewOnce: true
        });

        // Esperar 15 segundos antes de eliminar
        setTimeout(async () => {
            if (global.mensajeBotCloud) {
                await client.sendMessage(m.chat, { delete: global.mensajeBotCloud.key });
            }
            await client.sendMessage(m.chat, { delete: m.key });
        }, 30000);

    } catch (err) {
        console.error('Error al enviar el mensaje de /cloud:', err);
    }
}
break;
case 'download':
case 'upload':
case 'passwordshared': {
    try {
        switch (command) {
            case 'download':
                await client.sendMessage(m.chat, { react: { text: '⬇️', key: m.key } });
                global.mensajeBot5 = await client.sendMessage(from, {
                    image: { url: `https://i.ibb.co/mC4gG14z/Soporte-Cloud-y-Conexiones-Futuristas.png` },
                    caption: `*Aquí está el link de la nube privada del grupo*\n🌐 *https://cutt.ly/nubesoporteyaportes*\n\n*Aquí está la clave de la nube privada del grupo*\n🔐 \`@SoporteyAportes*\``
                });
                break;

            case 'upload':
                await client.sendMessage(m.chat, { react: { text: '⬆️', key: m.key } });
                global.mensajeBot5 = await client.sendMessage(from, {
                    image: { url: `https://i.ibb.co/mC4gG14z/Soporte-Cloud-y-Conexiones-Futuristas.png` },
                    caption: `*Aquí está el link para subir a la nube privada del grupo*\n\n*https://cutt.ly/1rtdPu40*`
                });
                break;

            case 'passwordshared':
                await client.sendMessage(m.chat, { react: { text: '🔐', key: m.key } });
                global.mensajeBot5 = await client.sendMessage(from, {
                    image: { url: `https://i.ibb.co/Z1VrdMpR/nube-azul-candado-candado-el-933463-22146.jpg` },
                    caption: `*Aquí está la clave de la nube privada del grupo*\n\n*@SoporteyAportes**`
                });
                break;
        }

        // Esperar 15 segundos antes de eliminar el mensaje
        setTimeout(async () => {
            if (global.mensajeBot5) {
                await client.sendMessage(m.chat, { delete: global.mensajeBot5.key });
            }
            await client.sendMessage(m.chat, { delete: m.key });
        }, 15000);

    } catch (err) {
        console.error('Error al enviar el mensaje:', err);
    }
}
break;
//Administtrador Modificado <- Esto entra el admin center
case 'owner': {
    const kontak = {
        "displayName": `${global.nameadmin}`,
        vcard: `BEGIN:VCARD\nVERSION:3.0\nN:;;;;\nFN: ${global.nama}\nitem1.TEL;waid=${global.owner}:${global.owner}\nitem1.X-ABLabel:\nPor favor no envíen spam a mi propietario\nURL;Email Owner:${global.email}\nORG: ${global.nameadmin}\nEND:VCARD`
    };

    client.sendMessage(from, {
        contacts: { contacts: [kontak] }
    }).then(async (sentMessage) => {
        try {
            await new Promise(resolve => setTimeout(resolve, 15000)); // Espera 15 segundos
            await client.sendMessage(m.chat, { delete: m.key }); // Elimina el mensaje del usuario
            await client.sendMessage(m.chat, { delete: sentMessage.key }); // Elimina el mensaje de respuesta
        } catch (err) {
            console.error("❌ Error eliminando mensajes:", err);
        }
    }).catch(err => {
        console.error("❌ Error al enviar el mensaje:", err);
    });
}
break;
//numero de la suerte de 3 a 4 digitos
case "NumeroSuerte": case "numerosuerte": {
    let luckyNumber = Math.floor(Math.random() * 900) + 100; // Números entre 100 y 999 (3 dígitos)
    if (Math.random() > 0.5) {
        luckyNumber = Math.floor(Math.random() * 9000) + 1000; // Números entre 1000 y 9999 (4 dígitos)
    }
    m.reply(`🍀 *Números de la suerte de hoy:* *${luckyNumber}* 🍀`);
	await client.sendMessage(m.chat, { delete: m.key });
};
break;
//Cual es mi suerte
case "cualesmisuerte": {
    let fortunes = [
        "🔮 ¡Hoy la suerte está de tu lado!",
        "⚡ Ten cuidado con las decisiones importantes hoy.",
        "🌞 ¡Recibirás una sorpresa agradable!",
        "💼 Se acerca una oportunidad de oro, ¡no la dejes pasar!",
        "🌱 Un nuevo comienzo está a la vuelta de la esquina, prepárate.",
        "🌙 El universo conspira a tu favor, mantén la calma y avanza.",
        "💖 El amor está cerca, abre tu corazón a nuevas posibilidades.",
        "🔥 El esfuerzo que has puesto pronto traerá sus frutos.",
        "🎉 Un momento de celebración se acerca, disfruta del presente.",
        "🌟 La creatividad será tu mejor aliada hoy, aprovecha el impulso.",
        "🌈 Se avecina un cambio positivo, ¡está por llegar!",
        "💡 La claridad que necesitas vendrá pronto, no pierdas la fe.",
        "🎶 La armonía y paz invadirán tu día, disfruta el momento.",
        "🌻 La naturaleza te regalará momentos de calma y reflexión.",
        "🎁 Alguien cercano te sorprenderá con un gesto especial.",
        "🚀 Las oportunidades de crecimiento personal están por llegar.",
        "⏳ Es momento de tomar decisiones que marcarán el futuro.",
        "🌍 Hoy es el día para pensar en grande y actuar con valentía.",
        "💎 La paciencia te llevará a descubrir tesoros escondidos.",
        "🔑 La solución que buscas está más cerca de lo que imaginas.",
        "🌸 Un ciclo que acaba, da paso a uno nuevo lleno de posibilidades.",
        "🌞 Este será un día lleno de luz y buenos momentos.",
        "🦋 La transformación personal es inevitable, ven con apertura.",
        "💥 Algo inesperado y emocionante sucederá en tu día.",
        "🧭 La dirección correcta está frente a ti, confía en tu intuición.",
        "🌟 Hoy es el día para brillar con todo tu potencial.",
        "🕊️ La paz interior será tu compañera, busca tranquilidad.",
        "🎬 Hoy es el día para escribir tu propia historia, ¡hazlo épico!",
        "🔥 La pasión por lo que haces te llevará a nuevas alturas.",
        "⚖️ La justicia y el equilibrio reinarán en tu vida hoy.",
        "💎 Las dificultades pasarán, y verás cómo todo mejora.",
        "🌙 La noche traerá descanso y nuevas perspectivas.",
        "🛤️ El camino que sigues es el correcto, sigue adelante.",
        "💭 Hoy, tus pensamientos se harán realidad, ten cuidado con ellos.",
        "🌷 Lo que siembres hoy dará frutos en el futuro cercano.",
        "🍀 Los pequeños detalles marcarán la diferencia, no los ignores.",
        "🎯 La concentración será clave para lograr tus metas hoy.",
        "💼 Se acercan nuevos proyectos que desafiarán tus capacidades.",
        "🍃 La naturaleza te traerá una sensación de renovación y frescura.",
        "💌 Alguien pensará en ti y te enviará un mensaje positivo.",
        "🎮 El esfuerzo te permitirá ganar lo que siempre has deseado.",
        "💫 Tu energía positiva será contagiante, ¡compártela!",
        "🎉 Un evento importante hará que este día sea inolvidable.",
        "🌅 Un nuevo amanecer trae consigo nuevas oportunidades.",
        "🎁 Este día tiene algo especial reservado solo para ti.",
        "💪 La fuerza y determinación te guiarán por el camino correcto.",
        "🎨 Hoy es un buen día para expresarte con creatividad y arte.",
        "🎤 ¡Es momento de compartir tu voz y ser escuchado!",
        "🏅 La victoria está cerca, sigue luchando con coraje.",
        "🧳 Este día te llevará a nuevas aventuras que cambiarán tu perspectiva.",
        "🍀 Los pequeños gestos de amabilidad hoy te traerán grandes recompensas.",
        "💃 La felicidad se encuentra en el movimiento, ¡baila y disfruta!"
    ];

    let randomFortune = fortunes[Math.floor(Math.random() * fortunes.length)];
    const message = await m.reply(`🔮 *Predicción del Día:* \n\n${randomFortune}`);

    // Elimina el mensaje del usuario que solicitó el comando después de 1 segundo (1000 ms)
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 1000); // 1000 ms = 1 segundo
};
break;
case "glitchtext": {
    if (!args.length) return m.reply("¡Ingresa un texto para convertirlo en glitch!");
    
    let text = args.join(" ");
    let glitch = text.split("").map(char => char + "̖̫͟").join("");
    
    m.reply(`🌌 *Texto Glitch:* \n\n${glitch}`);
};
break
case 'addcase': {
    if (!isCreator) return reply('¿Quién eres tú?');
    if (!text) return reply('¿Dónde está el case?');
    const fs = require('fs');
    const nombreArchivo = './start/system.js';
    const nuevoCase = `${text}`;
    fs.readFile(nombreArchivo, 'utf8', (err, data) => {
        if (err) {
            console.error('Ocurrió un error al leer el archivo:', err);
            return;
        }
        const posicionInicio = data.indexOf("case 'addcase':");

        if (posicionInicio !== -1) {
            const codigoCompleto = data.slice(0, posicionInicio) + '\n' + nuevoCase + '\n' + data.slice(posicionInicio);
            fs.writeFile(nombreArchivo, codigoCompleto, 'utf8', (err) => {
                if (err) {
                    reply('Ocurrió un error al escribir el archivo:', err);
                } else {
                    reply('El nuevo case se agregó con éxito.');
                }
            });
        } else {
            reply('No se pudo agregar el case en el archivo.');
        }
    });
};
break;
case 'delete': case 'del': {
    if (!m.quoted) throw "⚠️ No hay ningún mensaje citado para eliminar.";
    let { chat, id, participant } = m.quoted;
    let isFromBot = m.quoted.key.fromMe; // Nueva forma de verificar si es del bot
    if (!isFromBot) throw "❌ El mensaje no fue enviado por el bot.";
    await client.sendMessage(m.chat, { delete: { remoteJid: chat, fromMe: true, id, participant } });
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
// Stickers Creator
case 's': {
    console.log(`[LOG] Comando 's' recibido.`);

    const processedMessages = loadProcessedMessages();

    // ✅ Verificar si el mensaje ya fue procesado
    if (processedMessages.some(msg => msg.id === m.key.id)) {
        console.log(`[LOG] Mensaje ${m.key.id} ya procesado. Ignorando...`);
        return;
    }

    // ✅ Registrar mensaje como procesado antes de cualquier acción
    saveProcessedMessage(m.key.id);
    console.log(`[LOG] Procesando mensaje: ${m.key.id}`);

    await reaction(m.chat, '⏳');

    // Verificar si el mensaje contiene una imagen o un video
    const isImage = m.message.imageMessage;
    const isVideo = m.message.videoMessage;

    let media;
    if (isImage) {
        console.log(`[LOG] Imagen detectada. Descargando...`);
        media = await downloadMedia(m);
    } else if (isVideo) {
        console.log(`[LOG] Video detectado. Descargando...`);
        media = await downloadMedia(m);
    }

    if (media) {
        const stickerPath = 'sticker.webp';

        // Verificación de la ID del mensaje y el chat antes de eliminarlo
        console.log(`[DEBUG] m.chat: ${m.chat}, m.key.id: ${m.key.id}`);
        if (m.chat && m.key.id) {
            try {
                // Eliminar el mensaje original
                console.log(`[LOG] Eliminando mensaje con ID: ${m.key.id}`);
                await client.sendMessage(m.chat, { delete: { remoteJid: m.chat, fromMe: false, id: m.key.id, participant: m.sender } });
                console.log(`[LOG] Mensaje eliminado con ID: ${m.key.id}`);
            } catch (err) {
                console.log(`[ERROR] Error al eliminar el mensaje: ${err}`);
            }
        } else {
            console.log(`[ERROR] No se pudo obtener m.chat o m.key.id.`);
        }

        console.log(`[LOG] Procesando sticker...`);
        try {
            // Crear el sticker
            await createAndSendSticker(media, stickerPath, m.chat);
            console.log(`[LOG] Sticker enviado.`);
        } catch (err) {
            console.log(`[ERROR] Conversión fallida: ${err}`);
        }

        // Limpiar los archivos temporales
        try {
            cleanUpFiles([media, stickerPath]);
            console.log(`[LOG] Archivos eliminados correctamente.`);
        } catch (err) {
            console.log(`[WARNING] No se encontró el archivo para eliminar: ${stickerPath}`);
        }
    } else {
        console.log(`[LOG] No se recibió una imagen o video válido.`);
    }

    console.log(`[LOG] Proceso finalizado.`);
    return;
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
case 'setnombregrupo':  {
	if (!isCreator) throw mess.owner
    if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    if (!text) throw 'Texto ?'
    await client.groupUpdateSubject(m.chat, text).then((res) => m.reply(mess.success)).catch((err) => m.reply(jsonformat(err)))
	await client.sendMessage(m.chat, { delete: m.key });
}
}
break;
case 'setdescgrupo': case 'setdesk': {
    if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    if (!text) throw 'Text ?'
await client.groupUpdateDescription(m.chat, text).then((res) => m.reply(mess.success)).catch((err) => m.reply(jsonformat(err)))
await client.sendMessage(m.chat, { delete: m.key });
            }
break;
case 'setimagebot': {
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    if (!/image/.test(mime)) throw `Enviar/Responder imagen con subtítulo ${prefix + command}`
    if (/webp/.test(mime)) throw `Enviar/Responder imagen con subtítulo ${prefix + command}`
    let media = await client.downloadAndSaveMediaMessage(qmsg)
    await client.updateProfilePicture(botNumber, { url: media }).catch((err) => fs.unlinkSync(media))
    reply("Hecho.")
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
case 'setimagegroup': {
    if (!m.isGroup) throw mess.group
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    if (!/image/.test(mime)) throw `Enviar/Responder imagen con subtítulo ${prefix + command}`
    if (/webp/.test(mime)) throw `Enviar/Responder imagen con subtítulo${prefix + command}`
    let media = await client.downloadAndSaveMediaMessage(qmsg)
    await client.updateProfilePicture(m.chat, { url: media }).catch((err) => fs.unlinkSync(media))
    reply("Hecho.")
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
case 'linkgrupo': {
    if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    let response = await client.groupInviteCode(m.chat)
    client.sendText(m.chat, `https://chat.whatsapp.com/${response}\n\nLink Grupo : ${groupMetadata.subject}`, m, { detectLink: true })
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
case 'setnombrebot': {
	if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    if (!text) throw `Ejemplo : ${prefix + command} WhatsApp ✅`
    let name = await client.updateProfileName(text)
    reply(`El bot se renombró exitosamente.`)
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
case 'setdescbot': {
	if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    if (!text) throw `Este es un bot de WhatsApp llamado CHI-BOT`
    let name = await client.updateProfileStatus(text)
    reply(`Se cambió exitosamente el estado de biografía del bot a ${name}`)
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
//COMPONENTES DE SISTEMA AGREGADOS 13/03/2025
case 'waifuhot' :{
	let permisos = obtenerPermisos();
    // Verifica si el grupo está en la lista de permitidos o denegados
    if (permisos.denegados.includes(m.chat)) {
        return reply("⛔ Este grupo no tiene acceso a este comando.");
    }
    if (!permisos.permitidos.includes(m.chat)) {
        return reply("⚠️ Este grupo no está en la lista de permitidos.");
    }
await client.sendMessage(m.chat, {react: {text: '🥵', key: m.key}})
anu = await fetchJson(`https://waifu.pics/api/nsfw/waifu`)
buffer = await getBuffer(anu.url)
client.sendMessage(m.chat, { image: buffer, caption: `Aqui esta tu waifu hot`})
// Esperar 1 segundos antes de eliminar el mensaje del usuario
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 1000); // 1000 ms = 1 segundos
}
break;
case 'waifu': {
await client.sendMessage(m.chat, {react: {text: '🧝🏻‍♂️', key: m.key}})
anu = await fetchJson(`https://waifu.pics/api/sfw/waifu`)
buffer = await getBuffer(anu.url)
client.sendMessage(m.chat, { image: buffer, caption: `Aqui esta tu waifu`})
// Esperar 1 segundos antes de eliminar el mensaje del usuario
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 1000); // 1000 ms = 1 segundos
}
break;
case 'nekohot': {
	let permisos = obtenerPermisos();
    // Verifica si el grupo está en la lista de permitidos o denegados
    if (permisos.denegados.includes(m.chat)) {
        return reply("⛔ Este grupo no tiene acceso a este comando.");
    }
    if (!permisos.permitidos.includes(m.chat)) {
        return reply("⚠️ Este grupo no está en la lista de permitidos.");
    }
await client.sendMessage(m.chat, {react: {text: '🥵', key: m.key}})
anu = await fetchJson(`https://waifu.pics/api/nsfw/neko`)
buffer = await getBuffer(anu.url)
client.sendMessage(m.chat, { image: buffer, caption: `Aqui esta tu neko hot`}, )
// Esperar 1 segundos antes de eliminar el mensaje del usuario
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 1000); // 1000 ms = 1 segundos
}
break;
case 'neko': {
await client.sendMessage(m.chat, {react: {text: '🧝🏻‍♂️', key: m.key}})
anu = await fetchJson(`https://waifu.pics/api/sfw/neko`)
buffer = await getBuffer(anu.url)
client.sendMessage(m.chat, { image: buffer, caption: `Aqui esta tu neko`})
// Esperar 1 segundos antes de eliminar el mensaje del usuario
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 1000); // 1000 ms = 1 segundos
}
break;
//Cafe
case 'cafe': {
await client.sendMessage(m.chat, {react: {text: '☕', key: m.key}})
buffer = await getBuffer(`https://coffee.alexflipnote.dev/random`)
client.sendMessage(m.chat, { image: buffer, caption: `☕ Toma tu café`})
// Esperar 1 segundos antes de eliminar el mensaje del usuario
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 5000); // 1000 ms = 1 segundos
}
break;
//Saludo
case 'buendia' : case 'buendía':{
teks = `*Buenos dias a todos☀️*

*Les desea su Administrador y el BOT CHI 👋🏻*
*Dios los bendiga que tengan buen amanecer  y bonito dia laboral.* 
`
buendia = await getBuffer(`https://i.ibb.co/YTh5kvw6/Chobits-Chii.jpg`)
await client.sendMessage(m.chat, { image: buendia, caption : teks} )
await client.sendMessage(m.chat, { delete: m.key });
}
break;
//añadir palabra mala
case 'addbadword': {
	if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    if (!m.isGroup) {
        await client.sendMessage(m.chat, { text: "⚠️ Este comando solo puede usarse en grupos." });
        return;
    }

    const args = m.text.trim().split(/\s+/);
    const palabra = args.slice(1).join(" ").toLowerCase();

    if (!palabra) {
        await client.sendMessage(m.chat, { text: "⚠️ Debes escribir una palabra para añadir." });
        return;
    }

    const fs = require('fs');
    const badWordsFile = './database/badwords.json';

    // 📌 Función para cargar la lista de malas palabras
    function cargarBadWords() {
        try {
            if (!fs.existsSync(badWordsFile)) {
                fs.writeFileSync(badWordsFile, JSON.stringify({ palabras: [] }, null, 2));
            }
            const data = fs.readFileSync(badWordsFile, 'utf8');
            return JSON.parse(data).palabras || [];
        } catch (error) {
            console.error("⚠️ Error al leer badwords.json:", error.message);
            return [];
        }
    }

    // 📌 Función para guardar la lista de malas palabras
    function guardarBadWords(lista) {
        try {
            fs.writeFileSync(badWordsFile, JSON.stringify({ palabras: lista }, null, 2));
        } catch (error) {
            console.error("⚠️ Error al guardar badwords.json:", error.message);
        }
    }

    let badWords = cargarBadWords();

    if (badWords.includes(palabra)) {
        await client.sendMessage(m.chat, { text: "⚠️ Esa palabra ya está en la lista de malas palabras." });
        return;
    }

    badWords.push(palabra);
    guardarBadWords(badWords);

    await client.sendMessage(m.chat, { text: `✅ La palabra *${palabra}* ha sido añadida a la lista de malas palabras.` });
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
// Eliminar palabra mala
case 'delbadword': {
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
	if (!m.isGroup) {
        await client.sendMessage(m.chat, { text: "⚠️ Este comando solo puede usarse en grupos." });
        return;
    }
    const args = m.text.trim().split(/\s+/);
    const palabra = args.slice(1).join(" ").toLowerCase();
    if (!palabra) {
        await client.sendMessage(m.chat, { text: "⚠️ Debes escribir una palabra para eliminar." });
        return;
    }
    const fs = require('fs');
    const badWordsFile = './database/badwords.json';

    // 📌 Función para cargar la lista de malas palabras
    function cargarBadWords() {
        try {
            if (!fs.existsSync(badWordsFile)) {
                fs.writeFileSync(badWordsFile, JSON.stringify({ palabras: [] }, null, 2));
            }
            const data = fs.readFileSync(badWordsFile, 'utf8');
            return JSON.parse(data).palabras || [];
        } catch (error) {
            console.error("⚠️ Error al leer badwords.json:", error.message);
            return [];
        }
    }

    // 📌 Función para guardar la lista de malas palabras
    function guardarBadWords(lista) {
        try {
            fs.writeFileSync(badWordsFile, JSON.stringify({ palabras: lista }, null, 2));
        } catch (error) {
            console.error("⚠️ Error al guardar badwords.json:", error.message);
        }
    }

    let badWords = cargarBadWords();

    if (!badWords.includes(palabra)) {
        await client.sendMessage(m.chat, { text: "⚠️ Esa palabra no está en la lista de malas palabras." });
        return;
    }

    badWords = badWords.filter(word => word !== palabra);
    guardarBadWords(badWords);

    await client.sendMessage(m.chat, { text: `✅ La palabra *${palabra}* ha sido eliminada de la lista de malas palabras.` });
	await client.sendMessage(m.chat, { delete: m.key });
}
break;
// Cargar la lista de malas palabras
case 'listbadword': {
    // 📌 Función para cargar la lista de malas palabras
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
	function cargarBadWords() {
        try {
            if (!fs.existsSync(badWordsFile)) {
                fs.writeFileSync(badWordsFile, JSON.stringify({ palabras: [] }, null, 2));
            }
            const data = fs.readFileSync(badWordsFile, 'utf8');
            return JSON.parse(data).palabras || [];
        } catch (error) {
            console.error("⚠️ Error al leer badwords.json:", error.message);
            return [];
        }
    }
    let badWords = cargarBadWords();
    if (badWords.length === 0) {
        await client.sendMessage(m.chat, { text: "⚠️ La lista de malas palabras está vacía." });
    } else {
        const mensaje = `📜 *Lista de palabras prohibidas (${badWords.length}):*\n\n${badWords.map((word, index) => `${index + 1}. ${word}`).join("\n")}`;
        await client.sendMessage(m.chat, { text: mensaje });
    } 
await client.sendMessage(m.chat, { delete: m.key });
}
break;
// Mensaje de donación
case 'donacion': {
    await client.sendMessage(m.chat, { react: { text: '💱', key: m.key } }); 
    try {
        // Envía el mensaje de donación
        await client.sendMessage(from, {
            image: { url: `https://image.freepik.com/free-vector/donation_16734-172.jpg` },
            caption: `*🤝 ¡Apoya el Proyecto!*\n\n*Agradecemos tu colaboración para mantener el servicio activo y mejorar cada día. Cualquier donación es bienvenida 🙏.*\n\n💳 *Métodos de donación:*\n- *PayPal:* https://cutt.ly/DonacionSyA\n- *Nequi:* ${ownerNumber}\n- *Binance:*\n14FBn1ufBxs3xTBZ1Gm6Q3xB4GxF2n5aGm\n\n¡Gracias por tu apoyo!`
        });

        // Elimina el mensaje original solo si el mensaje de donación se envió correctamente
        await client.sendMessage(m.chat, { delete: m.key });

    } catch (err) {
        console.error("[ERROR] No se pudo enviar el mensaje de donación:", err);
        await client.sendMessage(m.chat, { text: '❌ Error al enviar el mensaje de donación.' });
    } 
}
break;
//Add musica y video al bot
case "YT2": case "yt2": case "Yt2": {
    if (!text) return reply(`\n*Ejemplo:* ${prefix + command} [nombre de la canción]\n`);
    await reaction(m.chat, '🎵');

    try {
        let mbut = await fetchJson(`https://ochinpo-helper.hf.space/yt?query=${encodeURIComponent(text)}`);
        let ahh = mbut.result;
        let crot = ahh.download.audio;
        let videoUrl = ahh.download.video;
        let title = ahh.title;
        let thumbnail = ahh.thumbnail;
        let duration = ahh.timestamp;
        let url = ahh.url;

        if (!crot || !videoUrl) return reply("❌ No se encontraron enlaces de descarga.");

        let nuevaConsulta = {
            query: text,
            title: title,
            duration: duration,
            url: url,
            audio: crot,
            video: videoUrl,
            thumbnail: thumbnail,
            date: new Date().toLocaleString(),
            requestedBy: senderNumber
        };

        guardarConsultasDeGrupo(m.chat, nuevaConsulta);
        
        let buttons = [
            { buttonId: `${prefix}audio`, buttonText: { displayText: '🎵 Audio' }, type: 1 },
            { buttonId: `${prefix}video`, buttonText: { displayText: '📹 Video' }, type: 1 }
        ];

        let buttonMessage = {
            image: { url: thumbnail },
            caption: `🎶 *Título:* ${title}\n⏳ *Duración:* ${duration}\n🔗 *URL:* ${url}\n\nSelecciona una opción para descargar:`,
            footer: 'Descargar desde YouTube',
            buttons: buttons,
            headerType: 6, 
            viewOnce: true
        };

        // Evita error de undefined en quoted
        let quotedMessage = m.quoted ? { quoted: m } : {};
        let sentMessage = await client.sendMessage(m.chat, buttonMessage, quotedMessage);

        // Eliminar mensaje del usuario
        await client.sendMessage(m.chat, { delete: m.key });

        // Guardar mensaje para eliminarlo después
        global.mensajeBot3 = sentMessage;
    } catch (err) {
        console.error(err);
        reply("❌ Ocurrió un error al obtener la canción.");
    }
}
break;
case "audio": {
    if (global.mensajeBot3) await client.sendMessage(m.chat, { delete: global.mensajeBot3.key });
    let grupo = m.chat;
    let consulta = cargarConsultasDeGrupo(grupo);
    if (!consulta) return reply("❌ No hay ninguna consulta guardada. Usa /play primero.");

    let url = consulta.url;
    if (!url) return reply("❌ No se encontró el enlace de video guardado.");

    console.log("🔗 URL obtenida:", url);
    await reaction(m.chat, '⏳');

	const audioPath = "./media-TEMP/audio.mp3";

    try {
        exec(`yt-dlp -F ${url}`, (error, stdout, stderr) => {
            if (error) {
                console.error("❌ Error al obtener formatos:", error);
                return reply("❌ No se pudieron obtener los formatos de audio.");
            }

            console.log("📊 Formatos disponibles:\n", stdout);

            let bestFormat = null;
            let match;

            // Expresión regular para capturar los formatos de audio "Default, low" y "Default, high"
            const regex = /^(\d+)\s+mp4\s+audio only\s+\|.*?\|\s+audio only.*?(Default, (low|high))/mg;
            
            while ((match = regex.exec(stdout)) !== null) {
                let formatID = match[1];  // ID del formato
                let quality = match[3];  // "low" o "high"

                // Siempre preferir "high" sobre "low"
                if (quality === "high") {
                    bestFormat = formatID;
                    break;  // Sale del loop si encuentra el mejor formato
                } else if (!bestFormat) {
                    bestFormat = formatID; // Guarda "low" si no hay otra mejor opción
                }
            }

            if (!bestFormat) {
                console.log("❌ No se pudo determinar la mejor calidad de audio.");
                return reply("❌ No se encontró un formato de audio adecuado.");
            }

            console.log(`🎶 Descargando audio con formato ID: ${bestFormat}`);
            reply(`🎶 Descargando audio con la mejor calidad disponible...`);

            exec(`yt-dlp -f ${bestFormat} -o "${audioPath}" ${url}`, async (err, stdout, stderr) => {
                if (err) {
                    console.error("❌ Error al descargar:", err);
                    return reply("❌ Error al descargar el audio.");
                }

                console.log("✅ Descarga completada.\n", stdout);
                await client.sendMessage(m.chat, {
                    audio: fs.readFileSync(audioPath),
                    mimetype: "audio/mpeg",
                    fileName: "audio.mp3",
                    ptt: false
                });

                fs.unlinkSync(audioPath);
                console.log("🗑️ Archivo de audio eliminado.");

                guardarConsultasDeGrupo(grupo, consulta);

                setTimeout(async () => {
                    await client.sendMessage(m.chat, { delete: m.key });
                }, 1000);
            });
        });
    } catch (err) {
        console.error(err);
        reply("❌ Error inesperado al procesar el audio.");
    }
}
break;
case "video": {
    if (global.mensajeBot3) await client.sendMessage(m.chat, { delete: global.mensajeBot3.key });

    let consulta = cargarConsultasDeGrupo(m.chat);
    if (!consulta) return reply("❌ No hay ninguna consulta guardada. Usa /play primero.");

    let url = consulta.url;
    if (!url) return reply("❌ No se encontró el enlace de video guardado.");

    console.log("🔗 URL obtenida:", url);
    await reaction(m.chat, '⏳');

    const videoPath = "./media-TEMP/video.mp4";

    try {
        exec(`yt-dlp -F ${url}`, (error, stdout) => {
            if (error) {
                console.error("❌ Error al obtener formatos:", error);
                return reply("❌ No se pudieron obtener los formatos de video.");
            }

            console.log("📊 Formatos disponibles:\n", stdout);

            // Extraer líneas relevantes
            const formatLines = stdout.split("\n").filter(line => /\b\d+\b/.test(line));

            // Filtrar solo formatos m3u8
            const videoFormats = formatLines.filter(line =>
                /mp4/.test(line) && /\d{3,4}x\d{3,4}/.test(line) && /m3u8/.test(line)
            );

            const audioFormats = formatLines.filter(line => /audio only/.test(line) && /m3u8/.test(line));

            if (videoFormats.length === 0 || audioFormats.length === 0) {
                console.log("❌ No se encontraron formatos adecuados.");
                return reply("❌ No hay formatos de video y audio disponibles.");
            }

            // Seleccionar el mejor video (mayor resolución)
            let bestVideo = videoFormats.reduce((max, format) => {
                const match = format.match(/(\d{3,4})x(\d{3,4})/);
                if (match) {
                    let width = parseInt(match[1]);
                    let height = parseInt(match[2]);
                    let resolution = width * height; // Comparar por área
                    return resolution > max.resolution ? { id: format.split(" ")[0], resolution } : max;
                }
                return max;
            }, { id: null, resolution: 0 });

            // Seleccionar el mejor audio
            let bestAudio = audioFormats.find(line => line.includes("234 ")) || audioFormats[0];
            bestAudio = bestAudio ? bestAudio.split(" ")[0] : null;

            if (!bestVideo.id || !bestAudio) {
                console.log("❌ No se pudo determinar la mejor calidad de video o audio.");
                return reply("❌ Error al determinar la calidad de video o audio.");
            }

            console.log(`📽️ Mejor calidad encontrada: ${bestVideo.resolution}p (ID: ${bestVideo.id}), Audio: ${bestAudio}`);
            reply(`📽️ Descargando video espere...`);

            // Forzar descarga con HLS
            exec(`yt-dlp -f ${bestVideo.id}+${bestAudio} --hls-prefer-native -o ${videoPath} ${url}`, async (err) => {
                if (err) {
                    console.error("❌ Error al descargar:", err);
                    return reply("❌ Error al descargar el video.");
                }

                console.log("✅ Descarga completada.");

                if (!fs.existsSync(videoPath)) {
                    console.error("❌ Error: El archivo de video no se generó.");
                    return reply("❌ Hubo un problema al descargar el video.");
                }

                await client.sendMessage(m.chat, {
                    video: fs.readFileSync(videoPath),
                    mimetype: "video/mp4",
                    fileName: "video.mp4"
                });

                fs.unlinkSync(videoPath);
                console.log("🗑️ Archivo de video eliminado.");

                setTimeout(async () => {
                    await client.sendMessage(m.chat, { delete: m.key });
                }, 1000);
            });
        });
    } catch (err) {
        console.error(err);
        reply("❌ Error inesperado al procesar el video.");
    }
}
break;
//Add musica y video al bot
case "YT": case "yt": case "Yt": {
    if (!text) return reply(`\n*Ejemplo:* ${prefix + command} [nombre de la canción]\n`);
    await reaction(m.chat, '🎵');

    try {
        let mbut = await fetchJson(`https://ochinpo-helper.hf.space/yt?query=${encodeURIComponent(text)}`);
        let ahh = mbut.result;
        let crot = ahh.download.audio;
        let videoUrl = ahh.download.video;
        let title = ahh.title;
        let thumbnail = ahh.thumbnail;
        let duration = ahh.timestamp;
        let url = ahh.url;
        if (!crot || !videoUrl) return reply("❌ No se encontraron enlaces de descarga.");

        let nuevaConsulta = {
            query: text,
            title: title,
            duration: duration,
            url: url,
            audio: crot,
            video: videoUrl,
            thumbnail: thumbnail,
            date: new Date().toLocaleString(),
            requestedBy: senderNumber
        };

        guardarConsultasDeGrupo(m.chat, nuevaConsulta);

        let buttons = [
            { buttonId: `${prefix}audio1 `, buttonText: { displayText: '🎵 Audio HD' }, type: 1 },
            { buttonId: `${prefix}video1 `, buttonText: { displayText: '📹 Video Mejor Calidad Disponible' }, type: 1 },
            { buttonId: `${prefix}video2 `, buttonText: { displayText: '📹 Video 720P o Menor' }, type: 1 }
        ];

        let buttonMessage = {
            image: { url: thumbnail },
            caption: `*Recuerda que debes esperar si un usuario está descargando sus canciones, gracias.*\n\n🎶 *Título:* ${title}\n⏳ *Duración:* ${duration}\n🔗 *URL:* ${url}\n\nSelecciona una opción para descargar:`,
            footer: 'Descargar desde YouTube',
            buttons: buttons,
            headerType: 6, 
            viewOnce: true
        };

        // Guardar el mensaje enviado
        let sentMessage = await client.sendMessage(m.chat, buttonMessage);

        // Eliminar el mensaje de invocación del comando
        await client.sendMessage(m.chat, { delete: m.key });

        // Guardar el mensaje para eliminación posterior
        global.mensajeBot2 = sentMessage;

    } catch (err) {
        console.error(err);
        reply("❌ Ocurrió un error al obtener la canción.");
    }
}
break;
case "audio1": {
	// ✅ Eliminar mensajes después de enviar el video
    if (global.mensajeBot2) await client.sendMessage(m.chat, { delete: global.mensajeBot2.key });
    //await client.sendMessage(m.chat, { delete: m.key });
	const fs = require("fs");
    const path = require("path");
    const { exec } = require("child_process");
    const ffmpeg = require("fluent-ffmpeg");
    let consulta = cargarConsultasDeGrupo(m.chat);
    if (!consulta) return reply("❌ No hay ninguna consulta guardada en este grupo. Usa /play primero.");
    
    let url = consulta.url;
    if (!url) return reply("❌ No se encontró el enlace de video guardado.");

    console.log(`🔗 URL obtenida desde el grupo ${m.chat}:`, url);
    await reaction(m.chat, '⏳');

    const mediaTempPath = path.resolve('./media-TEMP');
    if (!fs.existsSync(mediaTempPath)) fs.mkdirSync(mediaTempPath, { recursive: true });

    const audioTempPath = path.join(mediaTempPath, `audio_temp_${m.chat}.webm`);
    const finalAudioPath = path.join(mediaTempPath, `audio_final_${m.chat}.mp3`);

    exec(`yt-dlp -f "bestaudio" --user-agent "Mozilla/5.0 (Windows NT 10.0; Win64; x64)" -o "${audioTempPath}" ${url}`, (err) => {
        if (err) return reply("❌ Error al descargar el audio.");
        console.log("✅ Audio descargado con éxito.");

        if (!fs.existsSync(audioTempPath)) return reply("❌ No se encontró el archivo de audio para convertir.");

        ffmpeg().input(audioTempPath)
            .audioCodec("libmp3lame")
            .audioBitrate("320k")
            .output(finalAudioPath)
            .on("end", async () => {
                console.log("✅ Audio convertido a 320kbps correctamente.");
                await client.sendMessage(m.chat, {
                    audio: fs.readFileSync(finalAudioPath),
                    mimetype: "audio/mpeg",
                    fileName: "audio_320kbps.mp3",
                    ptt: false
                });
                fs.unlinkSync(audioTempPath);
                fs.unlinkSync(finalAudioPath);
                reply("✅ Audio enviado en calidad 320kbps.");
				
				setTimeout(async () => {
                    await client.sendMessage(m.chat, { delete: m.key });
                }, 1000);
            })
            .on("error", (convErr) => {
                console.error("❌ Error en la conversión:", convErr);
                reply("❌ Error al convertir el audio a 320kbps.");
            })
            .run();
    });
}
break;
case "video1": {
	// ✅ Eliminar mensajes después de enviar el video
    if (global.mensajeBot2) await client.sendMessage(m.chat, { delete: global.mensajeBot2.key });
    //await client.sendMessage(m.chat, { delete: m.key });
    const fs = require("fs");
    const path = require("path");
    const { exec } = require("child_process");
    const ffmpeg = require("fluent-ffmpeg");
    await reaction(m.chat, "⏳");

    let consulta = cargarConsultasDeGrupo(m.chat); // Cargar consulta específica del grupo
    if (!consulta) return reply("❌ No hay ninguna consulta guardada. Usa /play primero.");

    let url = consulta.url;
    if (!url) return reply("❌ No se encontró el enlace de video guardado.");

    console.log("🔗 URL obtenida:", url);
    await reaction(m.chat, "⏳");

    // 📂 Asegurar que la carpeta media-TEMP existe
    const mediaTempPath = path.resolve("./media-TEMP");
    if (!fs.existsSync(mediaTempPath)) {
        fs.mkdirSync(mediaTempPath, { recursive: true });
    }

    // 📌 Obtener el título del video
    let videoTitle = "video_final";
    try {
        const titleResult = execSync(`yt-dlp --get-title ${url}`).toString().trim();
        if (titleResult) videoTitle = titleResult.replace(/[<>:"/\\|?*]/g, "");
    } catch (titleError) {
        console.error("❌ Error al obtener el título del video:", titleError);
    }

    // 📂 Rutas de los archivos
    const videoPath = path.join(mediaTempPath, `video_${m.chat}.mp4`);
    const audioPath = path.join(mediaTempPath, `audio_${m.chat}.webm`);
    const finalVideoPath = path.join(mediaTempPath, `${videoTitle}_${m.chat}.mp4`);

    try {
        exec(`yt-dlp -F --user-agent "Mozilla/5.0 (Windows NT 10.0; Win64; x64)" ${url}`, (error, stdout) => {
            if (error) {
                console.error("❌ Error al obtener formatos:", error);
                return reply("❌ No se pudieron obtener los formatos de video.");
            }

            console.log("📊 Formatos disponibles:\n", stdout);

            let bestFormat = null;
            const lines = stdout.split("\n");

            lines.forEach((line) => {
                const match = line.match(/(\d+)\s+.+\s+(\d+)x(\d+)/);
                if (match) {
                    const formatId = match[1];
                    const resolution = parseInt(match[3]);

                    if (resolution >= 2160) return;
                    if (resolution === 1080) bestFormat = { id: formatId, resolution };
                    if (!bestFormat || (resolution < 1080 && resolution > bestFormat.resolution)) {
                        bestFormat = { id: formatId, resolution };
                    }
                }
            });

            if (!bestFormat) return reply("❌ No se encontró un formato de video adecuado.");

            console.log(`📹 Descargando video en ${bestFormat.resolution}p (ID: ${bestFormat.id})...`);
            exec(`yt-dlp -f "${bestFormat.id}" --user-agent "Mozilla/5.0 (Windows NT 10.0; Win64; x64)" -o "${videoPath}" ${url}`, (err) => {
                if (err) {
                    console.error("❌ Error al descargar video:", err);
                    return reply("❌ Error al descargar el video.");
                }

                console.log("✅ Video descargado con éxito.");
                exec(`yt-dlp -f "bestaudio" --user-agent "Mozilla/5.0 (Windows NT 10.0; Win64; x64)" -o "${audioPath}" ${url}`, (err) => {
                    if (err) {
                        console.error("❌ Error al descargar audio:", err);
                        return reply("❌ Error al descargar el audio.");
                    }

                    console.log("✅ Audio descargado con éxito.");

                    if (!fs.existsSync(videoPath) || !fs.existsSync(audioPath)) {
                        return reply("❌ No se encontraron archivos de video o audio para fusionar.");
                    }

                    console.log("🔄 Fusionando video y audio...");
                    ffmpeg()
                        .input(videoPath)
                        .input(audioPath)
                        .output(finalVideoPath)
                        .videoCodec("libx264")
                        .audioCodec("aac")
                        .on("end", async () => {
                            console.log("✅ Video y audio fusionados correctamente.");
                            await client.sendMessage(
                                m.chat,
                                {
                                    video: fs.readFileSync(finalVideoPath),
                                    mimetype: "video/mp4",
                                    fileName: `${videoTitle}.mp4`,
                                    caption: `✅ ${videoTitle} descargado en ${bestFormat.resolution}p.`,
                                }
                            );

                            fs.unlinkSync(videoPath);
                            fs.unlinkSync(audioPath);
                            fs.unlinkSync(finalVideoPath);
                            console.log("🗑️ Archivos temporales eliminados.");
                            reply("✅ Video enviado con éxito.");
							
							setTimeout(async () => {
							await client.sendMessage(m.chat, { delete: m.key });
							}, 1000);
                        })
                        .on("error", (convErr) => {
                            console.error("❌ Error en la conversión:", convErr);
                            reply("❌ Error al convertir el video.");
                        })
                        .run();
                });
            });
        });
    } catch (err) {
        console.error(err);
        reply("❌ Error inesperado al procesar el video.");
    }
}
break;
case "video2": {
	// ✅ Eliminar mensajes después de enviar el video
    if (global.mensajeBot2) await client.sendMessage(m.chat, { delete: global.mensajeBot2.key });
    //await client.sendMessage(m.chat, { delete: m.key });
    const fs = require("fs");
    const path = require("path");
    const { exec } = require("child_process");
    const ffmpeg = require("fluent-ffmpeg");
    await reaction(m.chat, "⏳");

    let consulta = cargarConsultasDeGrupo(m.chat); // Cargar consulta específica del grupo
    if (!consulta) return reply("❌ No hay ninguna consulta guardada. Usa /play primero.");

    let url = consulta.url;
    if (!url) return reply("❌ No se encontró el enlace de video guardado.");

    console.log("🔗 URL obtenida:", url);
    await reaction(m.chat, "⏳");

    // 📂 Asegurar que la carpeta media-TEMP existe
    const mediaTempPath = path.resolve("./media-TEMP");
    if (!fs.existsSync(mediaTempPath)) {
        fs.mkdirSync(mediaTempPath, { recursive: true });
    }

    // 📌 Obtener el título del video
    let videoTitle = "video_final";
    try {
        const titleResult = execSync(`yt-dlp --get-title ${url}`).toString().trim();
        if (titleResult) videoTitle = titleResult.replace(/[<>:"/\\|?*]/g, "");
    } catch (titleError) {
        console.error("❌ Error al obtener el título del video:", titleError);
    }

    // 📂 Rutas de los archivos
    const videoPath = path.join(mediaTempPath, `video_${m.chat}.mp4`);
    const audioPath = path.join(mediaTempPath, `audio_${m.chat}.webm`);
    const finalVideoPath = path.join(mediaTempPath, `${videoTitle}_${m.chat}.mp4`);

    try {
        exec(`yt-dlp -F --user-agent "Mozilla/5.0 (Windows NT 10.0; Win64; x64)" ${url}`, (error, stdout) => {
            if (error) {
                console.error("❌ Error al obtener formatos:", error);
                return reply("❌ No se pudieron obtener los formatos de video.");
            }

            console.log("📊 Formatos disponibles:\n", stdout);

            let bestFormat = null;
            const lines = stdout.split("\n");
            
            const resolutions = [720, 480, 360, 240, 144]; // Resoluciones en orden de preferencia

			let bestMatch = null;

			lines.forEach((line) => {
				const match = line.match(/(\d+)\s+.+\s+(\d+)x(\d+)/);
				if (match) {
					const formatId = match[1];
					const resolution = parseInt(match[3]);

					// Buscar la mejor coincidencia dentro de las resoluciones permitidas
					for (const preferredResolution of resolutions) {
						if (resolution === preferredResolution) {
							bestFormat = { id: formatId, resolution };
							return;
						} else if (resolution < preferredResolution && (!bestMatch || resolution > bestMatch.resolution)) {
							bestMatch = { id: formatId, resolution };
						}
					}
				}
			});

			// Si no encontramos la resolución exacta, tomamos la mejor coincidencia menor
			if (!bestFormat && bestMatch) {
				bestFormat = bestMatch;
			}

            if (!bestFormat) return reply("❌ No se encontró un formato de video adecuado.");

            console.log(`📹 Descargando video en ${bestFormat.resolution}p (ID: ${bestFormat.id})...`);
            exec(`yt-dlp -f "${bestFormat.id}" --user-agent "Mozilla/5.0 (Windows NT 10.0; Win64; x64)" -o "${videoPath}" ${url}`, (err) => {
                if (err) {
                    console.error("❌ Error al descargar video:", err);
                    return reply("❌ Error al descargar el video.");
                }

                console.log("✅ Video descargado con éxito.");
                exec(`yt-dlp -f "bestaudio" --user-agent "Mozilla/5.0 (Windows NT 10.0; Win64; x64)" -o "${audioPath}" ${url}`, (err) => {
                    if (err) {
                        console.error("❌ Error al descargar audio:", err);
                        return reply("❌ Error al descargar el audio.");
                    }

                    console.log("✅ Audio descargado con éxito.");

                    if (!fs.existsSync(videoPath) || !fs.existsSync(audioPath)) {
                        return reply("❌ No se encontraron archivos de video o audio para fusionar.");
                    }

                    console.log("🔄 Fusionando video y audio...");
                    ffmpeg()
                        .input(videoPath)
                        .input(audioPath)
                        .output(finalVideoPath)
                        .videoCodec("libx264")
                        .audioCodec("aac")
                        .on("end", async () => {
                            console.log("✅ Video y audio fusionados correctamente.");
                            await client.sendMessage(
                                m.chat,
                                {
                                    video: fs.readFileSync(finalVideoPath),
                                    mimetype: "video/mp4",
                                    fileName: `${videoTitle}.mp4`,
                                    caption: `✅ ${videoTitle} descargado en ${bestFormat.resolution}p.`,
                                }
                            );

                            fs.unlinkSync(videoPath);
                            fs.unlinkSync(audioPath);
                            fs.unlinkSync(finalVideoPath);
                            console.log("🗑️ Archivos temporales eliminados.");
                            reply("✅ Video enviado con éxito.");
							setTimeout(async () => {
							await client.sendMessage(m.chat, { delete: m.key });
							}, 1000);
                        })
                        .on("error", (convErr) => {
                            console.error("❌ Error en la conversión:", convErr);
                            reply("❌ Error al convertir el video.");
                        })
                        .run();
                });
            });
        });
    } catch (err) {
        console.error(err);
        reply("❌ Error inesperado al procesar el video.");
    }
}
break;
// YT Download Externo -> Corregido 27/03/2025
case "YText": case "ytext": {
    if (!text) return reply(`\n*Ejemplo:* ${prefix + command} [nombre de la canción]\n`);
    await reaction(m.chat, '🎵');

    try {
        let mbut = await fetchJson(`https://ochinpo-helper.hf.space/yt?query=${encodeURIComponent(text)}`);
        let ahh = mbut.result;
        let crot = ahh.download.audio; // URL de descarga del audio
        let videoUrl = ahh.download.video; // URL de descarga del video
        let title = ahh.title;
        let thumbnail = ahh.thumbnail;
        let duration = ahh.timestamp;
        let url = ahh.url; // URL del video original

        if (!crot || !videoUrl) return reply("❌ No se encontraron enlaces de descarga.");

        let grupo = m.chat; // ID del grupo

        // Guardar solo la última consulta en la base de datos
        let consulta = {
            query: text,
            title: title,
            duration: duration,
            url: url,
            audio: crot,
            video: videoUrl,
            thumbnail: thumbnail,
            date: new Date().toLocaleString(),
            requestedBy: senderNumber
        };

        guardarConsultasDeGrupo(grupo, consulta);

        // Crear botones interactivos
        let buttons = [
            { buttonId: `${prefix}audiourl`, buttonText: { displayText: '🎵 Url Audio' }, type: 1 },
            { buttonId: `${prefix}videourl`, buttonText: { displayText: '📹 Url Video' }, type: 1 }
        ];

        let buttonMessage = {
            image: { url: thumbnail },
            caption: `🎶 *Título:* ${title}\n⏳ *Duración:* ${duration}\n🔗 *URL:* ${url}\n\nSelecciona una opción para descargar:`,
            footer: 'Descargar desde YouTube',
            buttons: buttons,
            headerType: 6, 
            viewOnce: true
        };

        // Enviar el mensaje con botones y guardar el mensaje enviado
        let sentMessage = await client.sendMessage(m.chat, buttonMessage);

        // Guardar el mensaje para eliminarlo más tarde
        global.mensajeBot1 = sentMessage;
        
        // Eliminar el mensaje de invocación del comando
        await client.sendMessage(m.chat, { delete: m.key });

    } catch (err) {
        console.error("❌ Error al obtener la canción:", err);
        reply("❌ Ocurrió un error al obtener la canción.");
    }
}
break;
case 'audiourl':
case 'videourl': {
    try {
        // Inicializar global.grupo si no existe
        if (!global.grupo) global.grupo = {};

        // Cargar consultas desde el archivo JSON
        global.grupo.ConsultasDeGrupo = cargarConsultasDeGrupo(m.chat);

        // Validar si hay datos cargados
        if (!global.grupo.ConsultasDeGrupo) {
            console.log("❌ No se encontró ninguna consulta en el archivo JSON.");
            return reply("❌ No hay consulta de YouTube disponible para este chat.");
        }

        // Eliminar el mensaje anterior del bot
        if (global.mensajeBot1) await client.sendMessage(m.chat, { delete: global.mensajeBot1.key });
        await client.sendMessage(m.chat, { delete: m.key });

        // Obtener datos desde la consulta
        let consulta = global.grupo.ConsultasDeGrupo;
        let { title, audio, video } = consulta;

        // Validar según el comando
        let mensajeDescarga;
        if (command === 'audiourl') {
            if (!audio) return reply("❌ No se encontró enlace de descarga de audio.");
            mensajeDescarga = await client.sendMessage(m.chat, { text: `🎶 *Aquí está el enlace para descargar tu audio:*\n${audio}` });
        } else if (command === 'videourl') {
            if (!video) return reply("❌ No se encontró enlace de descarga de video.");
            mensajeDescarga = await client.sendMessage(m.chat, { text: `🎥 *Aquí está el enlace para descargar tu video:*\n${video}` });
        }

        // Comprobar si mensajeDescarga tiene un key válido antes de eliminar
        if (mensajeDescarga && mensajeDescarga.key) {
            setTimeout(async () => {
                try {
                    await client.sendMessage(m.chat, { delete: mensajeDescarga.key });
                } catch (err) {
                    console.error("❌ Error al eliminar el mensaje de descarga:", err);
                }
            }, 15000); // 15 segundos
        } else {
            console.log("⚠️ No se pudo obtener el mensaje para eliminarlo.");
        }

    } catch (err) {
        console.error(`❌ Error al obtener el ${command === 'audiourl' ? 'audio' : 'video'}:`, err);
        reply(`❌ Ocurrió un error al obtener el ${command === 'audiourl' ? 'audio' : 'video'}.`);
    }
}
break;
//////////////////
case 'infoadmin': {
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
	await client.sendMessage(m.chat, {react: {text: '✅', key: m.key}})
    if (!text) throw `Texto a mandar?\n\nEjemplo : ${prefix + command} Escribe tu texto`
    let getGroups = await client.groupFetchAllParticipating()
    let groups = Object.entries(getGroups).slice(0).map(entry => entry[1])
    let anu = groups.map(v => v.id)
    reply(`Envío de transmisiones a ${anu.length} Grupos,Se acabó el tiempo en ${anu.length * 1.5} segundos`)
        for (let i of anu) {
        await sleep(1500)
    let txt = `「👨🏻‍ *Informacion del Administrador*👩🏻‍ 」\n\n${text}`
    client.sendText(i, txt)
        }
    reply(`Su mensaje ha sido enviado con exito a ${anu.length} grupos`)
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
        }
break;
case 'infobot': {
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
	await client.sendMessage(m.chat, {react: {text: '✅', key: m.key}})
    if (!text) throw `Texto a mandar?\n\nEjemplo : ${prefix + command} Escribe tu texto`
    let getGroups = await client.groupFetchAllParticipating()
    let groups = Object.entries(getGroups).slice(0).map(entry => entry[1])
    let anu = groups.map(v => v.id)
    reply(`Envío de transmisiones a ${anu.length} Grupos,Se acabó el tiempo en ${anu.length * 1.5} segundos`)
        for (let i of anu) {
        await sleep(1500)
    let txt = `「💻 *Informacion del BOT*💻 」\n\n${text}`
    client.sendText(i, txt)
        }
    reply(`Su mensaje ha sido enviado con exito a ${anu.length} grupos`)
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
        }
break;
////////////Comandos Remoto/////////////
// OPCIÓN REMOTO
case 'remoto': {
    // Enviar el mensaje inicial con botones y guardar el mensaje enviado
    const sentMessage = await client.sendMessage(m.chat, {
        document: { url: 'https://i.ibb.co/twxYmjf8/Soportey-Aportes-BOT.jpg' },
        jpegThumbnail: fs.readFileSync("./start/lib/media/th.jpeg"),
        caption: "*Aquí encuentras los programas remotos que usamos para el soporte en red y demás*\n*Usa el que prefieras, pero te recomendamos uno en especial.*",
        contextInfo: {
            isForwarded: false,
            externalAdReply: {
                title: "Soporte y Aportes Globex",
                body: "Comunidad para la comunidad",
                thumbnailUrl: "https://i.ibb.co/twxYmjf8/Soportey-Aportes-BOT.jpg",
                sourceUrl: ``,
                mediaType: 1,
                renderLargerThumbnail: false
            }
        },
        buttons: [
            { buttonId: `${prefix}rustdesk`, buttonText: { displayText: `-> RustDesk <- 🖥️` }, type: 1 },
            { buttonId: `${prefix}anydesk`, buttonText: { displayText: `Anydesk 🖥️` }, type: 1 },
            { buttonId: `${prefix}teamviewer`, buttonText: { displayText: `Teamviewer 🖥️` }, type: 1 }
        ],
        headerType: 6,
        viewOnce: true
    });

    // Guardar el mensaje enviado para poder eliminarlo más tarde
	// Eliminar el mensaje de invocación del comando "remoto"
    await client.sendMessage(m.chat, { delete: m.key });
    global.mensajeBot = sentMessage;
    break;
}
// OPCIONES DE LOS BOTONES
case 'rustdesk':
case 'anydesk':
case 'teamviewer': {
    // Eliminar el mensaje anterior del bot
	if (global.mensajeBot) await client.sendMessage(m.chat, { delete: global.mensajeBot.key });
    await client.sendMessage(m.chat, { delete: m.key });
    // Ejecutar acciones según el botón seleccionado
    switch (command) {
        case 'rustdesk':
            await client.sendMessage(m.chat, { text: "🔧 *RustDesk - Soporte Remoto*\n\nRustDesk es una herramienta de acceso remoto segura y de código abierto.\n\n✅ Aquí tienes el enlace de descarga según tu sistema operativo:\n🌐 https://rustdesk.com/" });
            break;
        case 'anydesk':
            await client.sendMessage(m.chat, { text: "🔧 *AnyDesk - Soporte Remoto*\n\nAnyDesk ofrece una experiencia de acceso remoto rápida y fiable.\n\n✅ Aquí tienes el enlace de descarga según tu sistema operativo:\n🌐 https://anydesk.com/es/downloads/thank-you?dv=win_exe" });
            break;
        case 'teamviewer':
            await client.sendMessage(m.chat, { text: "🔧 *TeamViewer - Soporte Remoto*\n\nTeamViewer es una solución potente para el acceso remoto y el soporte técnico.\n\n✅ Aquí tienes el enlace de descarga según tu sistema operativo:\n🌐 https://www.teamviewer.com/es-mx/descarga-automatica-de-teamviewer/" });
            break;
    }
}
break;
//Seleccionar a todos
case 'tagall':{
    if (!isAdmins) return reply(mess.admin);
    if (!m.isGroup) return reply(mess.group);
	const textMessage = args.join(" ") || "nothing";
    let teks = `*Mensaje de Administrador* :\n> *${textMessage}*\n\n`;
	const groupMetadata = await client.groupMetadata(m.chat);
	const participants = groupMetadata.participants;
	for (let mem of participants) {
	teks += `@${mem.id.split("@")[0]}\n`;
	}
	client.sendMessage(m.chat, {
	text: teks,
	mentions: participants.map((a) => a.id)
	});
	// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
    }
break;
case 'entrar': {
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    if (!text) throw 'Ingresar enlace de grupo!'
    if (!isUrl(args[0]) && !args[0].includes('whatsapp.com')) throw 'Link Invalid!'
    reply(mess.wait)
    let result = args[0].split('https://chat.whatsapp.com/')[1]
    await client.groupAcceptInvite(result).then((res) => m.reply(jsonformat(res))).catch((err) => m.reply(jsonformat(err)))
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
case 'salir': {
	// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    await client.groupLeave(m.chat).then((res) => m.reply(jsonformat(res))).catch((err) => m.reply(jsonformat(err)))
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
case 'eliminar': {
	if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
	let users = m.mentionedJid[0] ? m.mentionedJid : m.quoted ? [m.quoted.sender] : [text.replace(/[^0-9]/g, '')+'@s.whatsapp.net']
	await client.groupParticipantsUpdate(m.chat, users, 'remove').then((res) => m.reply(jsonformat(res))).catch((err) => m.reply(jsonformat(err)))
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
case 'añadir': {
    if (!m.isGroup) throw mess.group;
    if (!isBotAdmins) throw mess.botAdmin;
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }

    let userId = m.mentionedJid[0]
        ? m.mentionedJid[0]
        : m.quoted
            ? m.quoted.sender
            : text.replace(/[^0-9]/g, '') + '@s.whatsapp.net';

    try {
        console.log(`[AÑADIR] 🔄 Intentando añadir a: ${userId}`);

        // Intentar añadir al usuario al grupo
        await client.groupParticipantsUpdate(m.chat, [userId], 'add');
        console.log(`[AÑADIR] ✅ Usuario añadido con éxito`);

        // Intentamos obtener el invite code
        let inviteCode;
        try {
            inviteCode = await client.groupInviteCode(m.chat);
            console.log(`[AÑADIR] 🔗 Invite Code obtenido: ${inviteCode}`);
        } catch (linkErr) {
            console.error(`[AÑADIR] ❌ Error obteniendo link del grupo:`, linkErr);
            inviteCode = null;
        }

        if (inviteCode) {
            const groupLink = `https://chat.whatsapp.com/${inviteCode}`;

            // Intentamos enviar el mensaje privado
            let privateMessage;
            try {
                privateMessage = await client.sendMessage(userId, {
                    text: `📨 *Te invitaron al grupo:* \n\nÚnete aquí:\n\n ${groupLink} \n\nEste mensaje se autodestruira en 2 minutos.`
                });
                console.log(`[AÑADIR] ✅ Mensaje enviado por privado a ${userId}`);
            } catch (errPrivado) {
                console.error(`[AÑADIR] ❌ No se pudo enviar el mensaje privado:`, errPrivado);
            }

            // Eliminar el mensaje privado en 2 minutos
            if (privateMessage?.key) {
                setTimeout(async () => {
                    try {
                        await client.sendMessage(userId, { delete: privateMessage.key });
                        console.log(`[AÑADIR] 🗑️ Mensaje privado eliminado.`);
                    } catch (delErr) {
                        console.error(`[AÑADIR] ❌ Error eliminando mensaje privado:`, delErr);
                    }
                }, 120000);
            }

            // Aviso en el grupo
            let avisoGrupo;
            try {
                avisoGrupo = await client.sendMessage(m.chat, {
                    text: `ℹ️ *No se pudo añadir directamente al usuario.* Se envió una invitación por privado.`,
                    mentions: [userId]
                });
                console.log(`[AÑADIR] ℹ️ Aviso enviado al grupo.`);
            } catch (errGrupo) {
                console.error(`[AÑADIR] ❌ No se pudo enviar aviso al grupo:`, errGrupo);
            }

            // Eliminar el aviso del grupo a los 10 segundos
            if (avisoGrupo?.key) {
                setTimeout(async () => {
                    try {
                        await client.sendMessage(m.chat, { delete: avisoGrupo.key });
                        console.log(`[AÑADIR] 🗑️ Aviso eliminado del grupo.`);
                    } catch (delErr) {
                        console.error(`[AÑADIR] ❌ Error eliminando aviso:`, delErr);
                    }
                }, 10000);
            }
        } else {
            console.error(`[AÑADIR] ❌ No se pudo obtener el link del grupo.`);
            await client.sendMessage(m.chat, {
                text: `❌ No se pudo obtener el link del grupo para invitar a @${userId.split('@')[0]}`,
                mentions: [userId]
            });
        }
    } catch (err) {
        console.error(`[AÑADIR] ❌ Error general:`, err);
        await client.sendMessage(m.chat, { text: "❌ Ocurrió un error al procesar la solicitud." });
    }

    // Eliminar el mensaje original
    await client.sendMessage(from, { delete: m.key });
}
break;
case 'promover': {
	if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
	let users = m.mentionedJid[0] ? m.mentionedJid : m.quoted ? [m.quoted.sender] : [text.replace(/[^0-9]/g, '')+'@s.whatsapp.net']
	await client.groupParticipantsUpdate(m.chat, users, 'promote').then((res) => m.reply(jsonformat(res))).catch((err) => m.reply(jsonformat(err)))
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
case 'demontar': {
	// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
	if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
	let users = m.mentionedJid[0] ? m.mentionedJid : m.quoted ? [m.quoted.sender] : [text.replace(/[^0-9]/g, '')+'@s.whatsapp.net']
	await client.groupParticipantsUpdate(m.chat, users, 'demote').then((res) => m.reply(jsonformat(res))).catch((err) => m.reply(jsonformat(err)))
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;        	
case "publico":{
	// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
    if (m.sender !== owner) {
    await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
    break;
    }
    client.public = true
    reply(`cambiado grupo exitosamente a ${command}`)
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
case "privado":{
	// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    } 
    client.public = false
    reply(`cambiado grupo exitosamente a ${command}`)
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
// Actualizar lista de grupos y usuarios
case 'updatelist': {
	if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    const listaGruposPath = './database/listagrupos.json';

    const loadListaGrupos = () => {
        if (!fs.existsSync(listaGruposPath)) {
            fs.writeFileSync(listaGruposPath, JSON.stringify({}, null, 2));
        }
        return JSON.parse(fs.readFileSync(listaGruposPath, 'utf8'));
    };

    const actualizarListaGrupos = async () => {
        const grupos = await client.groupFetchAllParticipating();
        let listaGrupos = {};

        for (const [groupId, groupInfo] of Object.entries(grupos)) {
            const participants = groupInfo.participants;

            listaGrupos[groupId] = {};  // Crear grupo en JSON

            for (let participant of participants) {
                let userId = participant.id;

                listaGrupos[groupId][userId] = {
                    "mensajes": 0,
                    "ultimaHora": new Date().toLocaleString("es-ES")
                };
            }
        }

        fs.writeFileSync(listaGruposPath, JSON.stringify(listaGrupos, null, 2));
    };

    await actualizarListaGrupos();
    await client.sendMessage(m.chat, { text: "✅ Lista de grupos y usuarios actualizada con éxito." });
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
// Verificar listas de grupos y usuarios
case 'verificarlistas': {
	if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    const listaGruposPath = './database/listagrupos.json';
    const contadorPath = './database/contador.json';
    const resultadoPath = './database/listaparaeliminar.json';

    // Cargar los archivos JSON
    const loadJSON = (path) => {
        if (!fs.existsSync(path)) return {};
        return JSON.parse(fs.readFileSync(path, 'utf8'));
    };

    const listaGrupos = loadJSON(listaGruposPath);
    const contador = loadJSON(contadorPath);

    let gruposParaEliminar = {};

    // Definir usuarios protegidos
    const usuariosProtegidos = [
        ...(Array.isArray(global.owner) ? global.owner : [global.owner]), 
        ...(Array.isArray(global.bot) ? global.bot : [global.bot])
    ].map(num => num.replace(/@s\.whatsapp\.net$/, '')); // Quita @s.whatsapp.net si existe

    // Recorrer los grupos en listagrupos.json
    for (const groupId in listaGrupos) {
        let usuariosAEliminar = {};

        // Recorrer los usuarios en la lista de grupos
        for (const userId in listaGrupos[groupId]) {
            const mensajesListaGrupo = listaGrupos[groupId][userId]?.mensajes || 0;
            const mensajesContador = contador[groupId]?.[userId]?.mensajes || 0;

            // Verificar si el usuario está en la lista de protegidos
            if (usuariosProtegidos.includes(userId.replace('@s.whatsapp.net', ''))) {
                continue; // Saltar a la siguiente iteración si es un usuario protegido
            }

            // Si el usuario NO existe en contador.json o tiene 0 mensajes en contador.json
            if (!contador[groupId] || !contador[groupId][userId] || mensajesContador === 0) {
                usuariosAEliminar[userId.replace('@s.whatsapp.net', '')] = {
                    mensajes: mensajesListaGrupo
                };
            }
        }

        // Si hay usuarios para eliminar, guardarlos en el grupo
        if (Object.keys(usuariosAEliminar).length > 0) {
            gruposParaEliminar[groupId] = usuariosAEliminar;
        }
    }

    // Guardar el resultado en `listaparaeliminar.json`
    fs.writeFileSync(resultadoPath, JSON.stringify(gruposParaEliminar, null, 2));

    // Construir mensaje para enviar
    let mensaje = "📢 *Verificación de Usuarios*\n\n";
    if (Object.keys(gruposParaEliminar).length === 0) {
        mensaje += "✅ No hay usuarios pendientes para eliminación.";
    } else {
        for (const groupId in gruposParaEliminar) {
            try {
                let groupMetadata = await client.groupMetadata(groupId);
                let groupName = groupMetadata.subject || "Grupo Desconocido";

                let totalUsuariosEliminar = Object.keys(gruposParaEliminar[groupId]).length;

                mensaje += `📌 *Grupo:* ${groupName} (${groupId})\n`;
                mensaje += `👥 *Total usuarios a eliminar:* ${totalUsuariosEliminar}\n`;
                mensaje += `🚨 *Usuarios próximos para eliminación:*\n`;

                for (const userId in gruposParaEliminar[groupId]) {
                    mensaje += `🔸 ${userId}\n`;
                }
                mensaje += "\n";
            } catch (error) {
                console.error(`Error obteniendo datos del grupo ${groupId}:`, error);
            }
        }
    }

    // Enviar mensaje al chat que hizo la solicitud
    await client.sendMessage(m.chat, { text: mensaje });
	// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
// Eliminar usuarios de la lista
case 'autodelgrupo': {
	if (!m.isGroup) throw mess.group
    if (!isBotAdmins) throw mess.botAdmin
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    const listaParaEliminarPath = './database/listaparaeliminar.json';
    const listaGruposPath = './database/listagrupos.json';

    // Cargar archivos JSON
    if (!fs.existsSync(listaParaEliminarPath) || !fs.existsSync(listaGruposPath)) {
        return await client.sendMessage(m.chat, { text: "⚠️ No se encontraron las listas necesarias." });
    }

    let listaParaEliminar = JSON.parse(fs.readFileSync(listaParaEliminarPath, 'utf8'));
    let listaGrupos = JSON.parse(fs.readFileSync(listaGruposPath, 'utf8'));

    // Obtener el ID del grupo donde se ejecutó el comando
    const groupId = m.chat;

    // Verificar si el grupo está en la lista
    if (!listaParaEliminar[groupId]) {
        return await client.sendMessage(m.chat, { text: "✅ No hay usuarios pendientes de eliminación en este grupo." });
    }

    // Definir usuarios protegidos
    const usuariosProtegidos = [
        ...(Array.isArray(global.owner) ? global.owner : [global.owner]), 
        ...(Array.isArray(global.bot) ? global.bot : [global.bot])
    ].map(num => num.replace(/@s\.whatsapp\.net$/, '')); // Quita @s.whatsapp.net si existe

    // Filtrar usuarios que no sean protegidos
    let usuariosAEliminar = Object.keys(listaParaEliminar[groupId]).filter(user => !usuariosProtegidos.includes(user));

    if (usuariosAEliminar.length === 0) {
        return await client.sendMessage(m.chat, { text: "✅ No hay usuarios a eliminar en este grupo (excepto los protegidos)." });
    }

    // Mensaje de inicio
    await client.sendMessage(m.chat, { text: `🚨 *Gestión de eliminación automática*\n\n📌 *Grupo:* ${groupId}\n👥 *Usuarios a eliminar:* ${usuariosAEliminar.length}\n\n⏳ Desactivando el chat...` });

    // 🔴 Desactivar el chat del grupo (solo administradores pueden enviar mensajes)
    try {
        await client.groupSettingUpdate(groupId, "announcement");
        await client.sendMessage(m.chat, { text: "🔒 *El chat del grupo ha sido desactivado temporalmente.*" });
    } catch (error) {
        console.error("❌ Error al desactivar el chat:", error);
    }

    // Recorrer usuarios para enviar mensaje y eliminarlos
    for (const userId of usuariosAEliminar) {
        const userJid = userId + '@s.whatsapp.net';

        // Enviar mensaje privado de advertencia
        const mensajePrivado = `⚠️ *Lo sentimos, pero serás eliminado del grupo.*\n\nNo has estado activo o no has aportado al grupo.\nSi crees que esto es un error, contacta con *${global.owner}*`;

        try {
            await client.sendMessage(userJid, { text: mensajePrivado });
        } catch (error) {
            console.error(`No se pudo enviar mensaje a ${userJid}:`, error);
        }

        // Eliminar del grupo
        try {
            await client.groupParticipantsUpdate(groupId, [userJid], "remove");
            console.log(`✅ Usuario eliminado: ${userId}`);
        } catch (error) {
            console.error(`❌ Error al eliminar ${userId}:`, error);
        }

        // Esperar 2 segundos entre eliminaciones para evitar bloqueos
        await new Promise(resolve => setTimeout(resolve, 2000));

        // 🔴 Eliminar usuario de `listaparaeliminar.json` y `listagrupos.json`
        delete listaParaEliminar[groupId][userId];
        if (listaGrupos[groupId] && listaGrupos[groupId][userId]) {
            delete listaGrupos[groupId][userId];
        }
    }

    // Si el grupo quedó vacío en `listaparaeliminar.json`, eliminarlo
    if (Object.keys(listaParaEliminar[groupId]).length === 0) {
        delete listaParaEliminar[groupId];
    }

    // Guardar los archivos actualizados
    fs.writeFileSync(listaParaEliminarPath, JSON.stringify(listaParaEliminar, null, 2));
    fs.writeFileSync(listaGruposPath, JSON.stringify(listaGrupos, null, 2));

    // 🔓 Reactivar el chat del grupo (permitir mensajes de todos)
    try {
        await client.groupSettingUpdate(groupId, "not_announcement");
        await client.sendMessage(m.chat, { text: "✅ *El chat del grupo ha sido reactivado.*" });
    } catch (error) {
        console.error("❌ Error al reactivar el chat:", error);
    }

    // Mensaje final en el grupo
    await client.sendMessage(m.chat, { text: `✅ *Proceso completado.*\nSe eliminaron ${usuariosAEliminar.length} usuarios del grupo y fueron removidos de las listas.` });
	// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
// Comando para agregar un grupo
case "añadirpermisos": {
    if (!m.isGroup) return reply("❌ Este comando solo funciona en grupos.");
    if (!isAdmins) return reply("⛔ Solo administradores pueden usar este comando.");
	if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
    let permisos = obtenerPermisos();

    // Si el grupo está en denegados, lo eliminamos
    permisos.denegados = permisos.denegados.filter(id => id !== m.chat);

    // Agregar a permitidos si no está ya
    if (!permisos.permitidos.includes(m.chat)) {
        permisos.permitidos.push(m.chat);
        guardarPermisos(permisos);
        reply("✅ Este grupo ahora tiene permiso para usar los comandos ocultos.");
    } else {
        reply("⚠️ Este grupo ya tiene permiso.");
    }
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
// Comando para eliminar un grupo
case "quitarpermisos": {
    if (!m.isGroup) return reply("❌ Este comando solo funciona en grupos.");
    if (!isAdmins) return reply("⛔ Solo administradores pueden usar este comando.");
	if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar los comandos ocultos" });
        break;
    }
    let permisos = obtenerPermisos();

    // Si el grupo está en permitidos, lo eliminamos
    permisos.permitidos = permisos.permitidos.filter(id => id !== m.chat);

    // Agregar a denegados si no está ya
    if (!permisos.denegados.includes(m.chat)) {
        permisos.denegados.push(m.chat);
        guardarPermisos(permisos);
        reply("❌ Este grupo ha sido denegado y ya no podrá usar el comando.");
    } else {
        reply("⚠️ Este grupo ya está denegado.");
    }
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
// Comando para listar grupos con permisos
case "listarpermisos": {
    if (m.sender !== owner) {
        await client.sendMessage(m.chat, { text: "❌ No tienes permisos para usar este comando." });
        break;
    }
	let permisos = obtenerPermisos();
    let permitidos = permisos.permitidos.length > 0 ? permisos.permitidos.join("\n") : "Ninguno";
    let denegados = permisos.denegados.length > 0 ? permisos.denegados.join("\n") : "Ninguno";

    reply(`📜 *Lista de permisos en grupos*\n\n✅ *Permitidos:*\n${permitidos}\n\n⛔ *Denegados:*\n${denegados}`);
		// Eliminar el mensaje del usuario después de procesar
    await client.sendMessage(from, { delete: m.key });
}
break;
// 📌 Añadir un grupo a "saludados"
case "añadirsaludos": {
    if (!m.isGroup) return reply("❌ Este comando solo funciona en grupos.");
    if (!isAdmins) return reply("⛔ Solo administradores pueden usar este comando.");

    const reply = async (text) => {
        return await client.sendMessage(m.chat, { text });
    };

    let saludos = obtenerSaludos();
    let mensajeRespuesta;

    if (!saludos.saludados.includes(m.chat)) {
        saludos.saludados.push(m.chat);
        saludos.nosaludados = saludos.nosaludados.filter(id => id !== m.chat); // Eliminar si estaba en "nosaludados"
        guardarSaludos(saludos);
        mensajeRespuesta = await reply("✅ Este grupo ha sido añadido a la lista de saludados.");
    } else {
        mensajeRespuesta = await reply("⚠️ Este grupo ya está en la lista de saludados.");
    }

    // Espera 5 segundos y elimina el mensaje de respuesta
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
    }, 5000);

    // También elimina el mensaje del usuario después de 5 segundos
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 5000);
}
break;
// ❌ Eliminar un grupo de "saludados" y pasarlo a "nosaludados"
case "eliminarsaludos": {
    if (!m.isGroup) return reply("❌ Este comando solo funciona en grupos.");
    if (!isAdmins) return reply("⛔ Solo administradores pueden usar este comando.");

    const reply = async (text) => {
        return await client.sendMessage(m.chat, { text });
    };

    let saludos = obtenerSaludos();
    let mensajeRespuesta;

    if (saludos.saludados.includes(m.chat)) {
        saludos.saludados = saludos.saludados.filter(id => id !== m.chat);
        saludos.nosaludados.push(m.chat); // Mover a "nosaludados"
        guardarSaludos(saludos);
        mensajeRespuesta = await reply("✅ Este grupo ha sido eliminado de la lista de saludados y agregado a 'nosaludados'.");
    } else {
        mensajeRespuesta = await reply("⚠️ Este grupo no estaba en la lista de saludados.");
    }

    // Espera 5 segundos y elimina el mensaje
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
    }, 5000);

    // También elimina el mensaje del usuario después de 5 segundos
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 5000);
}
break;
// 📜 Listar todos los grupos "saludados" y "nosaludados"
case "listasaludados": {
    try {
        let saludos = obtenerSaludos();

        if (!saludos || !saludos.saludados || !saludos.nosaludados) {
            return reply("⚠️ No se encontraron datos en la base de saludos.");
        }

        const obtenerNombres = async (ids) => {
            const resultados = [];

            for (const id of ids) {
                try {
                    const metadata = await client.groupMetadata(id);
                    resultados.push(`• ${metadata.subject}\n   ${id}`);
                } catch (error) {
                    resultados.push(`• (Nombre no disponible)\n   ${id}`);
                }
            }

            return resultados.join("\n\n");
        };

        let listaSaludados = saludos.saludados.length ? await obtenerNombres(saludos.saludados) : "Ninguno";
        let listaNoSaludados = saludos.nosaludados.length ? await obtenerNombres(saludos.nosaludados) : "Ninguno";

        let mensaje = `📜 *Lista de grupos:*\n\n`;
        mensaje += `✅ *Saludados:*\n${listaSaludados}\n\n`;
        mensaje += `❌ *No Saludados:*\n${listaNoSaludados}`;

        let mensajeRespuesta = await reply(mensaje);

        // Eliminar mensaje de respuesta a los 15 segundos
        setTimeout(async () => {
            await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
        }, 15000);

        // También eliminar mensaje del usuario a los 15 segundos
        setTimeout(async () => {
            await client.sendMessage(m.chat, { delete: m.key });
        }, 15000);

    } catch (error) {
        console.error("[ERROR] Al listar saludados:", error);
        reply("❌ Ocurrió un error al listar los saludados.");
    }
}
break;
// 📜 Listar todos los grupos registrados
case "grupolistout": {
    const groupData = JSON.parse(fs.readFileSync(groupDBPath));
    const entries = Object.entries(groupData);

    if (!args[0]) {
        let text = "📋 *Lista de Grupos Registrados:*\n\n";

        entries.forEach(([id, data], i) => {
            const estado = data.validated ? "✅ Sí" : "❌ No";
            const bloqueado = data.bloqueado ? "🔒 Sí" : "🔓 No";
            const admin = data.isAdmin ? "✅ Sí" : "❌ No";
            const nombre = data.groupName.length > 30 ? data.groupName.slice(0, 30) + "..." : data.groupName;
            const icono = data.validated ? "🟢" : "🟡";

            text += `*${i + 1}. ${icono} ${nombre}*\n`;
            text += `🆔 \`${id}\`\n`;
            text += `✅ Validado: ${estado}\n`;
            text += `🔒 Bloqueado: ${bloqueado}\n`;
            text += `👑 Admin: ${admin}\n\n`;
        });

        text += "📤 Usa el comando: `/grupolistout [número]`\n";
        text += "Ejemplo: `/grupolistout 3` para que el bot salga de ese grupo.";

        await m.reply(text);
        return;
    }

    const index = parseInt(args[0]) - 1;
    if (isNaN(index) || index < 0 || index >= entries.length) {
        return m.reply("❌ Número inválido. Usa `/grupolistout` para ver la lista de grupos disponibles.");
    }

    const [groupId, groupInfo] = entries[index];

    try {
        await client.groupLeave(groupId);

        // Eliminar el grupo del archivo de grupos
        delete groupData[groupId];
        fs.writeFileSync(groupDBPath, JSON.stringify(groupData, null, 2));

        // También eliminar de la lista de saludos si está
        //const saludosPath = "./database/saludos.json";
        if (fs.existsSync(saludos)) {
            const saludosData = JSON.parse(fs.readFileSync(saludos));

            const indexSaludado = saludosData.saludados.indexOf(groupId);
            if (indexSaludado !== -1) {
                saludosData.saludados.splice(indexSaludado, 1);
                fs.writeFileSync(saludosPath, JSON.stringify(saludosData, null, 2));
                console.log(`🗑️ Grupo ${groupId} eliminado de saludados.`);
            }
        }

        await m.reply(`✅ El bot ha salido del grupo *${groupInfo.groupName}* y ha sido eliminado de la lista.`);

    } catch (error) {
        console.error("❌ Error al salir del grupo o eliminarlo de la lista:", error);
        await m.reply("❌ Ocurrió un error al intentar salir del grupo o actualizar la base de datos.");
    }

    break;
}
// Comando para añadir grupo de musica
case "activarautomusica": {
    if (!m.isGroup) return reply("❌ Este comando solo funciona en grupos.");
    if (!isAdmins) return reply("⛔ Solo administradores pueden usar este comando.");

    const reply = async (text) => {
        return await client.sendMessage(m.chat, { text });
    };

    let grupos = obtenerGruposMusicales();
    let mensajeRespuesta;

    if (!grupos.activos.includes(m.chat)) {
        grupos.activos.push(m.chat);
        grupos.inactivos = grupos.inactivos.filter(id => id !== m.chat); // eliminar si estaba en inactivos
        guardarGruposMusicales(grupos);
        mensajeRespuesta = await reply("✅ Este grupo ha sido añadido a la lista de *activos*.");
    } else {
        mensajeRespuesta = await reply("⚠️ Este grupo ya está en la lista de activos.");
    }

    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
    }, 5000);

    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 5000);
}
break;
// ❌ Eliminar grupo de "activos" y pasarlo a "inactivos"
case "desactivarautomusica": {
    if (!m.isGroup) return reply("❌ Este comando solo funciona en grupos.");
    if (!isAdmins) return reply("⛔ Solo administradores pueden usar este comando.");

    const reply = async (text) => {
        return await client.sendMessage(m.chat, { text });
    };

    let grupos = obtenerGruposMusicales();
    let mensajeRespuesta;

    if (grupos.activos.includes(m.chat)) {
        grupos.activos = grupos.activos.filter(id => id !== m.chat);
        if (!grupos.inactivos.includes(m.chat)) grupos.inactivos.push(m.chat);
        guardarGruposMusicales(grupos);
        mensajeRespuesta = await reply("✅ Este grupo ha sido eliminado de *activos* y añadido a *inactivos*.");
    } else {
        mensajeRespuesta = await reply("⚠️ Este grupo no estaba en la lista de activos.");
    }

    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
    }, 5000);

    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 5000);
}
break;
// 📜 Listar todos los grupos "activos" e "inactivos"
case "listagrupomusica": {
    try {
        let grupos = obtenerGruposMusicales();

        if (!grupos || !grupos.activos || !grupos.inactivos) {
            return reply("⚠️ No se encontraron datos en la base de grupos.");
        }

        const obtenerNombres = async (ids) => {
            const resultados = [];

            for (const id of ids) {
                try {
                    const metadata = await client.groupMetadata(id);
                    resultados.push(`• ${metadata.subject}\n   ${id}`);
                } catch (error) {
                    resultados.push(`• (Nombre no disponible)\n   ${id}`);
                }
            }

            return resultados.join("\n\n");
        };

        let listaActivos = grupos.activos.length ? await obtenerNombres(grupos.activos) : "Ninguno";
        let listaInactivos = grupos.inactivos.length ? await obtenerNombres(grupos.inactivos) : "Ninguno";

        let mensaje = `📜 *Lista de grupos musicales:*\n\n`;
        mensaje += `✅ *Activos:*\n${listaActivos}\n\n`;
        mensaje += `❌ *Inactivos:*\n${listaInactivos}`;

        let mensajeRespuesta = await reply(mensaje);

        // Eliminar mensaje de respuesta a los 15 segundos
        setTimeout(async () => {
            await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
        }, 15000);

        // También eliminar mensaje del usuario a los 15 segundos
        setTimeout(async () => {
            await client.sendMessage(m.chat, { delete: m.key });
        }, 15000);

    } catch (error) {
        console.error("[ERROR] Al listar grupos musicales:", error);
        reply("❌ Ocurrió un error al listar los grupos musicales.");
    }
}
break;// Comando para añadir grupo de sismos (activar)
case "activarsismos": {
    if (!m.isGroup) return reply("❌ Este comando solo funciona en grupos.");
    if (!isAdmins) return reply("⛔ Solo administradores pueden usar este comando.");

    const reply = async (text) => {
        return await client.sendMessage(m.chat, { text });
    };

    let grupos = obtenerGruposSismos(); // función para grupos sismos
    let mensajeRespuesta;

    if (!grupos.activos.includes(m.chat)) {
        grupos.activos.push(m.chat);
        grupos.inactivos = grupos.inactivos.filter(id => id !== m.chat); // eliminar si estaba en inactivos
        guardarGruposSismos(grupos);
        mensajeRespuesta = await reply("✅ Este grupo ha sido añadido a la lista de *activos*.");
    } else {
        mensajeRespuesta = await reply("⚠️ Este grupo ya está en la lista de activos.");
    }

    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
    }, 5000);

    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 5000);
}
break;

// Comando para desactivar grupo de sismos (pasarlo a inactivos)
case "desactivarsismos": {
    if (!m.isGroup) return reply("❌ Este comando solo funciona en grupos.");
    if (!isAdmins) return reply("⛔ Solo administradores pueden usar este comando.");

    const reply = async (text) => {
        return await client.sendMessage(m.chat, { text });
    };

    let grupos = obtenerGruposSismos();
    let mensajeRespuesta;

    if (grupos.activos.includes(m.chat)) {
        grupos.activos = grupos.activos.filter(id => id !== m.chat);
        if (!grupos.inactivos.includes(m.chat)) grupos.inactivos.push(m.chat);
        guardarGruposSismos(grupos);
        mensajeRespuesta = await reply("✅ Este grupo ha sido eliminado de *activos* y añadido a *inactivos*.");
    } else {
        mensajeRespuesta = await reply("⚠️ Este grupo no estaba en la lista de activos.");
    }

    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
    }, 5000);

    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 5000);
}
break;

// 📜 Listar todos los grupos sismos "activos" e "inactivos"
case "listagruposismos": {
    try {
        let grupos = obtenerGruposSismos();

        if (!grupos || !grupos.activos || !grupos.inactivos) {
            return reply("⚠️ No se encontraron datos en la base de grupos.");
        }

        const obtenerNombres = async (ids) => {
            const resultados = [];

            for (const id of ids) {
                try {
                    const metadata = await client.groupMetadata(id);
                    resultados.push(`• ${metadata.subject}\n   ${id}`);
                } catch (error) {
                    resultados.push(`• (Nombre no disponible)\n   ${id}`);
                }
            }

            return resultados.join("\n\n");
        };

        let listaActivos = grupos.activos.length ? await obtenerNombres(grupos.activos) : "Ninguno";
        let listaInactivos = grupos.inactivos.length ? await obtenerNombres(grupos.inactivos) : "Ninguno";

        let mensaje = `📜 *Lista de grupos de sismos:*\n\n`;
        mensaje += `✅ *Activos:*\n${listaActivos}\n\n`;
        mensaje += `❌ *Inactivos:*\n${listaInactivos}`;

        let mensajeRespuesta = await reply(mensaje);

        // Eliminar mensaje de respuesta a los 15 segundos
        setTimeout(async () => {
            await client.sendMessage(m.chat, { delete: mensajeRespuesta.key });
        }, 15000);

        // También eliminar mensaje del usuario a los 15 segundos
        setTimeout(async () => {
            await client.sendMessage(m.chat, { delete: m.key });
        }, 15000);

    } catch (error) {
        console.error("[ERROR] Al listar grupos de sismos:", error);
        reply("❌ Ocurrió un error al listar los grupos de sismos.");
    }
}
break;
// Comando para mostrar las reglas del grupo
case 'reglas': {
    if (!m.isGroup) throw mess.group;

    const reglasPath = path.join(__dirname, '../database/reglas.json');
    let reglasTexto = "📜 *No hay reglas disponibles.*";

    try {
        const data = fs.readFileSync(reglasPath, 'utf8');
        const reglasJson = JSON.parse(data);

        if (reglasJson.reglas && reglasJson.reglas.length > 0) {
            reglasTexto = "📜 *Reglas del grupo:*\n\n" + reglasJson.reglas.join('\n');
        }
    } catch (error) {
        console.error("Error leyendo reglas.json:", error);
    }

    const sentMsg = await client.sendMessage(m.chat, { text: reglasTexto });

    // Eliminar mensaje después de 30 segundos (30000 ms)
    setTimeout(async () => {
        try {
            await client.sendMessage(m.chat, {
                delete: sentMsg.key
            });
        } catch (err) {
            console.error("❌ No se pudo eliminar el mensaje:", err);
        }
    }, 30000);
}
break;
// Comando para descargar contenido de Instagram
case 'igdl': {
    if (!text) {
        console.log('[IGDL] ❌ No se proporcionó una URL.');
        return replynano(`Debes proporcionar una URL de un video, publicación, reel o imagen de Instagram.`);
    }

    const solicitante = `@${m.sender.split('@')[0]}`;
    console.log(`[IGDL] 🟡 Solicitando contenido desde: ${text}`);
    client.sendMessage(m.chat, { react: { text: `✅`, key: m.key } });

    try {
        const data = await fetchJson(`https://api.siputzx.my.id/api/d/igdl?url=${encodeURIComponent(text)}`);
        console.log('[IGDL] ✅ Respuesta de API recibida.');

        if (data && data.data && data.data.length > 0) {
            console.log(`[IGDL] 📦 Se encontraron ${data.data.length} medios.`);

            for (const item of data.data) {
                const mediaUrl = item.url;
                const mensaje = `¡Aquí tienes! 🔥`;

                console.log(`[IGDL] 🔗 Media detectada: ${mediaUrl}`);

                if (
                    mediaUrl.includes('dst-jpg') ||
                    mediaUrl.includes('.jpg') ||
                    mediaUrl.includes('.jpeg') ||
                    mediaUrl.includes('image')
                ) {
                    console.log('[IGDL] 🖼️ Enviando imagen...');
                    await client.sendMessage(m.chat, {
                        image: { url: mediaUrl },
                        caption: mensaje,
                        mentions: [m.sender]
                    });
                } else {
                    console.log('[IGDL] 🎬 Enviando video...');
                    await client.sendMessage(m.chat, {
                        video: { url: mediaUrl },
                        caption: mensaje,
                        mentions: [m.sender]
                    });
                }

                console.log('[IGDL] ✅ Medio enviado con éxito.');
                break; // Solo enviar el primero
            }

            // 🗑️ Eliminar el mensaje del usuario
            await client.sendMessage(m.chat, { delete: m.key });

        } else {
            console.log('[IGDL] ⚠️ No se encontraron medios en la respuesta.');
            await client.sendMessage(m.chat, { text: 'Lo siento, no se encontró ningún medio.' });
        }
    } catch (error) {
        console.error('[IGDL] ❌ Error al obtener el contenido de Instagram:', error);
        await client.sendMessage(m.chat, { text: 'Ocurrió un error al intentar obtener el contenido.' });
    }
}
break;
// Comando para mostrar la versión del bot
case 'version': {
    try {
        // Ruta del archivo build.json
        const filePath = path.join('./settings/build.js');

        // Verificar si el archivo existe
        if (!fs.existsSync(filePath)) {
            return reply("⚠️ El archivo de versión no existe.");
        }

        // Leer el archivo build.json
        const data = JSON.parse(fs.readFileSync(filePath, 'utf8'));
        const { build, version } = data;

        // Responder con la versión del bot
        let mensaje = `🤖 *Versión del Bot*\n\n` +
                      `🔧 *Build:* ${build}\n` +
                      `📦 *Versión:* ${version}`;

        // Enviar el mensaje de la versión
        const sentMessage = await client.sendMessage(m.chat, { text: mensaje });

        // Esperar 15 segundos y luego eliminar ambos mensajes
        setTimeout(async () => {
            try {
                // Eliminar el mensaje de la versión
                await client.sendMessage(m.chat, { delete: sentMessage.key });

                // Eliminar el mensaje del comando enviado por el usuario
                await client.sendMessage(m.chat, { delete: m.key });
            } catch (err) {
                console.error("❌ Error al eliminar los mensajes:", err);
            }
        }, 15000);

    } catch (error) {
        console.error("❌ Error al obtener la versión del bot:", error);
        reply("❌ Ocurrió un error al obtener la versión del bot.");
    }
}
break;    
// Comando para buscar wallpapers
case 'wallpaper': {
    if (!text) throw 'Por favor ingrese el título de la imagen que desea buscar.'

    const fondosPath = path.join(__dirname, '../lib/assets/versiculos/fondos')
    if (!fs.existsSync(fondosPath)) fs.mkdirSync(fondosPath, { recursive: true })

    
    const resultados = await wallpaper(text)
    console.log(`[WALLPAPER] ✅ ${resultados.length} resultados encontrados.`)

    const cantidad = 5
    let enviados = 0

    for (let resultado of resultados) {
        if (enviados >= cantidad) break

        let imagenUrl = resultado.image.find(img => /\.(jpg|jpeg|png|webp)$/i.test(img))
        if (!imagenUrl) continue

        const hash = path.basename(imagenUrl).split('?')[0]
        const nombreBase = `fondo_${Date.now()}_${Math.floor(Math.random() * 1000)}`
        const extension = path.extname(imagenUrl)
        const inputPath = path.join(fondosPath, `${nombreBase}${extension}`)
        const outputPath = path.join(fondosPath, `${nombreBase}.jpg`)

        const archivoExistente = fs.readdirSync(fondosPath).find(archivo => archivo.includes(hash))
        if (archivoExistente) {
            console.log('[WALLPAPER] ⏩ Imagen duplicada, se omite.')
            continue
        }

        try {
            const respuesta = await axios.get(imagenUrl, { responseType: 'arraybuffer' })
            fs.writeFileSync(inputPath, respuesta.data)
        } catch (err) {
            console.warn('[WALLPAPER] ❌ Error al descargar la imagen:', err.message)
            continue
        }

        if (extension === '.webp') {
            console.log('[WALLPAPER] 🔄 Convirtiendo imagen .webp a .jpg...')
            try {
                await sharp(inputPath).jpeg().toFile(outputPath)
            } catch (err) {
                console.warn('[WALLPAPER] ❌ Error al convertir .webp:', err.message)
                continue
            }
        }

        console.log(`[WALLPAPER] 🚀 Enviando imagen a: ${m.chat}`)
        try {
            client.sendMessage(m.chat, {
                image: fs.readFileSync(extension === '.webp' ? outputPath : inputPath),
                //caption: `🖼️ *Título:* ${resultado.title}\n📂 *Categoría:* ${resultado.type}\n🔗 *Fuente:* ${resultado.source}`
            })

            console.log(`[WALLPAPER] ✅ Imagen guardada y enviada (${enviados + 1}/${cantidad})`)
            enviados++
        } catch (err) {
            console.warn('[WALLPAPER] ❌ Error al enviar la imagen:', err.message)
        }
    }

    // 🔚 Limpieza final: eliminar todos los .webp sobrantes
    try {
        const archivos = fs.readdirSync(fondosPath)
        const webps = archivos.filter(file => file.endsWith('.webp'))
        for (let file of webps) {
            const ruta = path.join(fondosPath, file)
            try {
                await fs.promises.unlink(ruta)
                console.log(`[WALLPAPER] 🧹 Eliminado .webp sobrante: ${file}`)
            } catch (err) {
                console.warn(`[WALLPAPER] ⚠️ No se pudo eliminar ${file}:`, err.message)
            }
        }
    } catch (err) {
        console.warn('[WALLPAPER] ⚠️ Error al limpiar archivos .webp:', err.message)
    }

    if (enviados === 0) {
        client.sendMessage(m.chat, { text: '⚠️ No se pudo enviar ninguna imagen. Intente con otra palabra.' })
    }
}
break;
// Comando para buscar imágenes en Pinterest
case "pinterest": {
    if (!text) {
        return m.reply("❌ Escribe un término de búsqueda.\nEj: /pinterest paisaje");
    }

    await m.reply(`🔍 Buscando imágenes de *${text}* en Pinterest...`);

    try {
        const resultados = await pinterest2(text);
        if (resultados.length === 0) {
            return m.reply("❌ No se encontraron imágenes.");
        }

        const url = resultados[0];

        await client.sendMessage(m.chat, {
            image: { url },
            caption: `🖼️ Resultado de *${text}*\n🔗 ${url}`
        }, { quoted: m });

    } catch (error) {
        console.error(`[Pinterest CMD] ❌ Error:`, error);
        m.reply("❌ Hubo un error al buscar la imagen.");
    }
    break;
}
// Comando para reiniciar el bot
case "reiniciar": {
    if (!isAdmins) return Reply("⛔ Solo administradores pueden usar este comando.");
    const mensajeConfirmacion = await m.reply("🔄 Reiniciando el bot en 5 segundos...");
    const archivos = fs.readdirSync("./session").filter(i => i !== "creds.json");
    for (let archivo of archivos) {
        fs.unlinkSync(`./session/${archivo}`);
    }
    // Esperar 5 segundos antes de reiniciar
    setTimeout(async () => {
        try {
            // Eliminar mensaje del comando
            await client.sendMessage(m.chat, { delete: m.key });
            // Eliminar mensaje de "reiniciando"
            if (mensajeConfirmacion && mensajeConfirmacion.key) {
                await client.sendMessage(m.chat, { delete: mensajeConfirmacion.key });
            }
        } catch (err) {
            console.error("❌ Error eliminando mensajes antes del reinicio:", err.message);
        }
        // Reiniciar el bot
        spawn(process.argv[0], [process.argv[1]], {
            detached: true,
            stdio: "inherit"
        });
        process.exit(); // Finalizar el proceso actual
    }, 5000);
}
break;
// Comando para descargar videos de Facebook
case 'fbdl': {
    if (!args[0]) {
        await client.sendMessage(from, {
            text: '📎 Por favor, proporciona el enlace del video de Facebook.\n\nEjemplo:\n`/fbdl https://www.facebook.com/ejemplo`'
        }, { quoted: m });
        break;
    }

    const url = args[0];
    console.log(`[FBDL] 🔗 Enlace recibido: ${url}`);

    const acortarURL = async (longUrl) => {
        try {
            console.log(`[FBDL] 🔗 Acortando URL: ${longUrl}`);
            const res = await fetch(`https://tinyurl.com/api-create.php?url=${encodeURIComponent(longUrl)}`);
            const shortUrl = await res.text();
            console.log(`[FBDL] ✅ URL acortada: ${shortUrl}`);
            return shortUrl;
        } catch (err) {
            console.error(`[FBDL] ❌ Error acortando URL: ${err}`);
            return longUrl;
        }
    };

    try {
        console.log(`[FBDL] ⏳ Solicitando información a la API...`);
        const response = await fetch(`https://api.vreden.web.id/api/fbdl?url=${encodeURIComponent(url)}`);
        const result = await response.json();

        if (!result?.data?.hd_url && !result?.data?.sd_url) {
            console.log(`[FBDL] ⚠️ No se encontró ninguna URL de video válida.`);
            await client.sendMessage(from, {
                text: '❌ No se pudo obtener el video. Verifica el enlace o intenta más tarde.'
            }, { quoted: m });
            break;
        }

        const { hd_url, sd_url, title } = result.data;
        const videoUrl = hd_url || sd_url;

        // Descargar el video como buffer
        console.log(`[FBDL] ⏬ Descargando video...`);
        const axios = require('axios');
        const videoResponse = await axios.get(videoUrl, { responseType: 'arraybuffer' });

        console.log(`[FBDL] 🎞️ Enviando video desde buffer: ${title}`);
        const videoMsg = await client.sendMessage(from, {
            video: videoResponse.data,
            mimetype: 'video/mp4',
            caption: `🎬 *Título:* ${title}`
        }, { quoted: m });
        console.log(`[FBDL] ✅ Video enviado sin metadata.`);

        const shortUrl = await acortarURL(videoUrl);

        console.log(`[FBDL] ⏳ Esperando 3 segundos para enviar el enlace...`);
        const urlMessage = await new Promise(resolve => {
            setTimeout(async () => {
                const msg = await client.sendMessage(from, {
                    text: `⏱️ *Este enlace se eliminará pronto:*\n${shortUrl}`
                });
                console.log(`[FBDL] 🔗 Enlace enviado: ${shortUrl}`);
                resolve(msg);
            }, 3000);
        });

        // Borrar después de 30 segundos
        console.log(`[FBDL] ⏳ Esperando 30 segundos para eliminar el enlace y el comando...`);
        setTimeout(async () => {
            try {
                if (urlMessage.key) {
                    await client.sendMessage(from, { delete: urlMessage.key });
                    console.log(`[FBDL] ❌ Mensaje del enlace eliminado.`);
                }
                if (m.key) {
                    await client.sendMessage(from, { delete: m.key });
                    console.log(`[FBDL] ❌ Comando del usuario eliminado.`);
                }
            } catch (deleteError) {
                console.error(`[FBDL] ❌ Error eliminando mensajes: ${deleteError}`);
            }
        }, 30000);

    } catch (err) {
        console.error("[FBDL] ❌ Error general:", err);
        await client.sendMessage(from, {
            text: '⚠️ Ocurrió un error al procesar el enlace. Intenta nuevamente.'
        }, { quoted: m });
    }

    break;
}
case 'upload': {
    const { uptotelegra } = require('../scrape/upload'); // ajusta la ruta según corresponda
    const { fromBuffer } = require('file-type');
    const path = require('path');

    if (!m.quoted || !m.quoted.message) {
        return client.sendMessage(from, {
            text: '📎 Responde a un archivo (imagen/video/documento) para subirlo a Telegraph.'
        }, { quoted: m });
    }

    const mime = m.quoted.mtype || '';
    if (!/image|video|document/.test(mime)) {
        return client.sendMessage(from, {
            text: '⚠️ El archivo debe ser una imagen, video o documento.'
        }, { quoted: m });
    }

    try {
        const mediaBuffer = await client.downloadMediaMessage(m.quoted);
        const fileType = await fromBuffer(mediaBuffer);
        const fileExt = fileType?.ext || 'bin';
        const tempDir = './media-Temp';
        if (!fs.existsSync(tempDir)) fs.mkdirSync(tempDir);
        const filePath = path.join(tempDir, `upload_file.${fileExt}`);

        fs.writeFileSync(filePath, mediaBuffer);
        console.log(`[UPLOAD] ✅ Archivo guardado temporalmente: ${filePath}`);

        const link = await uptotelegra(filePath);

        await client.sendMessage(from, {
            text: `✅ Archivo subido con éxito:\n🔗 ${link}`
        }, { quoted: m });

        fs.unlinkSync(filePath); // limpieza
        console.log(`[UPLOAD] 🗑️ Archivo temporal eliminado.`);
    } catch (err) {
        console.error(`[UPLOAD] ❌ Error al subir:`, err);
        await client.sendMessage(from, {
            text: '❌ Error al subir el archivo. Intenta de nuevo.'
        }, { quoted: m });
    }
    break;
}
// Comando para descargar videos de TikTok
case 'tiktokdl': {
    if (!args[0]) return reply('❗ Proporciona un enlace de TikTok.');
    let url = args[0];
    const { tiklydown } = require('../scrape/tiktok');

    try {
        console.log(`Procesando enlace de TikTok: ${url}`); // Log para verificar que el enlace está llegando
        const res = await tiklydown(url); // Usamos tiklydown en lugar de dlpanda

        //console.log('Resultado de tiklydown:', res); // Log para verificar qué datos se reciben de tiklydown

        // Verificamos que ambos, video sin marca y audio, estén presentes
        if (!res.video || !res.video.noWatermark || !res.music || !res.music.play_url) {
            console.log('No se pudo obtener el video sin marca o el audio'); // Log si faltan datos
            return reply('❌ No se pudo obtener el video o el audio.');
        }

        global.tiktok = global.tiktok || {};
        global.tiktok[m.chat] = {
            audio: res.music.play_url,
            video: res.video.noWatermark
        };

        // Log para verificar los datos de audio y video antes de crear los botones
        console.log('Datos de audio y video guardados:', global.tiktok[m.chat]);

        // Botones para elegir qué descargar
        let buttons = [
            { buttonId: `${prefix}tkmedia audio`, buttonText: { displayText: '🎵 Descargar Audio' }, type: 1 },
            { buttonId: `${prefix}tkmedia video`, buttonText: { displayText: '📹 Descargar Video' }, type: 1 }
        ];

        let buttonMessage = {
            image: { url: res.video.cover || 'https://i.imgur.com/xxl1p4N.jpg' },
            caption: `Recuerde esperar a que la descarga se finalize antes de otra consulta\n\n🎵 *Título:* ${res.title || 'Desconocido'}\n\nSelecciona qué quieres descargar:`,
            footer: 'Descarga de TikTok',
            buttons,
            headerType: 6,
            viewOnce: true
        };

        // Log antes de enviar el mensaje
        //console.log('Enviando mensaje con los botones:', buttonMessage);
        // Enviar el mensaje con botones y guardar el mensaje enviado
        let sentMessage = await client.sendMessage(m.chat, buttonMessage);
        await client.sendMessage(m.chat, { delete: m.key }); // Eliminar el mensaje original del usuario
        // Guardar el mensaje para eliminarlo más tarde
        global.mensajeBottiktok = sentMessage;
    } catch (e) {
        console.error('Error al procesar el enlace de TikTok:', e); // Log detallado del error
        reply('⚠️ Hubo un error al procesar el enlace.');
    }

    break;
}

case 'tkmedia': {
    if (!global.tiktok || !global.tiktok[m.chat]) return reply('❌ No hay datos disponibles o ha caducado.')

    const tipo = args[0]?.toLowerCase()
    if (!['audio', 'video'].includes(tipo)) return reply('❗ Usa el comando así:\n.tkmedia audio\n.tkmedia video')
    
    // Eliminar el mensaje anterior del bot
    if (global.mensajeBottiktok) await client.sendMessage(m.chat, { delete: global.mensajeBottiktok.key });
    

    if (tipo === 'audio') {
        if (!global.tiktok[m.chat].audio) return reply('❌ El audio no está disponible.')
        await client.sendMessage(m.chat, {
            audio: { url: global.tiktok[m.chat].audio },
            mimetype: 'audio/mpeg',
            ptt: false
        }, { quoted: m })
    }

    if (tipo === 'video') {
        if (!global.tiktok[m.chat].video) return reply('❌ El video no está disponible.')
        await client.sendMessage(m.chat, {
            video: { url: global.tiktok[m.chat].video },
            caption: '🎬 Aquí tienes el video sin marca de agua.'
        }, { quoted: m })
    }

    break
}
  
// Comando para enviar la lista de música
case 'musica2000':
    automusic.enviarLista(m.chat);
    break;


case 'bot': case 'chibot': case 'chi': {
    await m.reply(`🤖 *Tontito me buscas con el comando /menu*`);
    // Eliminar el mensaje del usuario después de 5 segundos
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }, 5000);
    // También eliminar el mensaje del bot después de 5 segundos
    setTimeout(async () => {
        await client.sendMessage(m.chat, { delete: m.key });
    }
    , 5000);
}
break;


/*
case 'play': {
    if (!text) throw `Example: ${prefix + command} story wa anime`;

    let yts = require("yt-search");
    let search = await yts(text);
    let anu = search.videos[Math.floor(Math.random() * search.videos.length)];

    let caption = `
🎶 *Título:* ${anu.title}
🆔 *ID:* ${anu.videoId}
⏳ *Duración:* ${anu.timestamp}
👤 *Autor:* ${anu.author.name}
📺 *Canal:* ${anu.author.url}
🔗 *URL:* ${anu.url}`;

    // Crear botones interactivos
    let buttons = [
        { buttonId: `Ytmp3 ${anu.url}`, buttonText: { displayText: '🎵 Descargar Audio' }, type: 1 },
        { buttonId: `Ytmp4 ${anu.url}`, buttonText: { displayText: '📹 Descargar Video' }, type: 1 }
    ];

    let buttonMessage = {
        image: { url: anu.thumbnail },
		text: caption,
        footer: 'Descargar desde YouTube',
        buttons: buttons,
        headerType: 6, 
        viewOnce: true
    };

    await client.sendMessage(m.chat, buttonMessage, { quoted: m });
}
break;

case 'ytmp3': case 'ytaudio': {
    let { yta } = require('./lib/ytdl');
    if (!text) throw `Example : ${prefix + command} https://youtube.com/watch?v=PtFMh6Tccag 128kbps`;

    let quality = args[1] ? args[1] : '128kbps';
    
    console.log("🔍 Solicitando descarga de audio...");
    console.log("📎 URL:", text);
    console.log("🎶 Calidad:", quality);

    let media = await yta(text, quality);

    console.log("✅ Descarga completada:");
    console.log("📌 Título:", media.title);
    console.log("🔗 Enlace de descarga:", media.dl_link);
    console.log("📏 Tamaño del archivo:", media.filesize);
    console.log("🖼 Miniatura:", media.thumb);

    if (media.filesize >= 100000) return m.reply('❌ El archivo supera el límite permitido: ' + util.format(media));

    client.sendImage(m.chat, media.thumb, `⭔ Título: ${media.title}\n⭔ URL: ${isUrl(text)}\n⭔ Extensión: MP3\n⭔ Calidad: ${args[1] || '128kbps'}`, m);
    client.sendMessage(m.chat, { audio: { url: media.dl_link }, mimetype: 'audio/mpeg', fileName: `${media.title}.mp3` }, { quoted: m });
}
break;

case 'ytmp4': case 'ytvideo': {
    let { ytv } = require('./lib/ytdl');
    if (!text) throw `Example : ${prefix + command} https://youtube.com/watch?v=PtFMh6Tccag 360p`;

    let quality = args[1] ? args[1] : '360p';

    console.log("🔍 Solicitando descarga de video...");
    console.log("📎 URL:", text);
    console.log("🎥 Calidad:", quality);

    let media = await ytv(text, quality);

    console.log("✅ Descarga completada:");
    console.log("📌 Título:", media.title);
    console.log("🔗 Enlace de descarga:", media.dl_link);
    console.log("📏 Tamaño del archivo:", media.filesize);

    if (media.filesize >= 100000) return m.reply('❌ El archivo supera el límite permitido: ' + util.format(media));

    client.sendMessage(m.chat, { 
        video: { url: media.dl_link }, 
        mimetype: 'video/mp4', 
        fileName: `${media.title}.mp4`, 
        caption: `⭔ Título: ${media.title}\n⭔ URL: ${isUrl(text)}\n⭔ Extensión: MP4\n⭔ Resolución: ${args[1] || '360p'}` 
    }, { quoted: m });
}
break;
/*case "audio": {
    let consulta = cargarYTDB();
    if (!consulta) return reply("❌ No hay ninguna consulta guardada. Usa /play primero.");

    let crot = consulta.audio; // URL del audio desde la base de datos
    if (!crot) return reply("❌ No se encontró el enlace de audio guardado.");

    await reaction(m.chat, '⏳');
    const enviarAudio = async (intento = 1) => {
        try {
            await client.sendMessage(m.chat, {
                audio: { url: crot },
                mimetype: "audio/mpeg",
                fileName: "audio.mp3",
                ptt: true
            }, { quoted: m });

            reply("✅ Audio descargado con éxito.");
        } catch (err) {
            if (intento === 1) {
                reply("⚠️ Error al descargar el audio, intentando 1 vez más...");
                await enviarAudio(2); // Reintento
            } else {
                console.error(err);
                reply("❌ No se pudo descargar el audio después de un intento.");
            }
        }
    };

    enviarAudio();
}
break;

case "video": {
    let consulta = cargarYTDB();
    if (!consulta) return reply("❌ No hay ninguna consulta guardada. Usa /play primero.");

    let videoUrl = consulta.video; // URL del video desde la base de datos
    if (!videoUrl) return reply("❌ No se encontró el enlace de video guardado.");
	
    await reaction(m.chat, '⏳');
    const enviarVideo = async (intento = 1) => {
        try {
            await client.sendMessage(m.chat, {
                video: { url: videoUrl },
                mimetype: "video/mp4",
                fileName: "video.mp4"
            }, { quoted: m });

            reply("✅ Video descargado con éxito.");
        } catch (err) {
            if (intento === 1) {
                reply("⚠️ Error al descargar el video, intentando 1 vez más...");
                await enviarVideo(2); // Reintento
            } else {
                console.error(err);
                reply("❌ No se pudo descargar el video después de un intento.");
            }
        }
    };

    enviarVideo();
}
break;*/





case "jadibot": {
    await reaction(m.chat, '✅')
    try {
    await jadibot(client, m, m.sender)
    } catch (error) {
    await reply(util.format(error), command)
    }
    }
break;     
case "stopjadibot": {
    await reaction(m.chat, '✅')
    if (m.key.fromMe) return
    try {
    await stopjadibot(client, m, m.sender)
    } catch (error) {
    await reply(util.format(error), command)
    }
    }
break;	
case "listjadibot": {
    if (m.key.fromMe) return
    try {
    listjadibot(client, m)
    } catch (error) {
    await reply(util.format(error), command)
    }
    }
break;           
                
            default:
			
                if (budy.startsWith('$')) {
                    if (!Access) return;
                    exec(budy.slice(2), (err, stdout) => {
                        if (err) return reply(err)
                        if (stdout) return reply(stdout);
                    });
                }
                
                if (budy.startsWith('>')) {
                    if (!Access) return;
                    try {
                        let evaled = await eval(budy.slice(2));
                        if (typeof evaled !== 'string') evaled = require('util').inspect(evaled);
                        await m.reply(evaled);
                    } catch (err) {
                        m.reply(String(err));
                    }
                }
        
                if (budy.startsWith('<')) {
                    if (!Access) return
                    let kode = budy.trim().split(/ +/)[0]
                    let teks
                    try {
                        teks = await eval(`(async () => { ${kode == ">>" ? "return" : ""} ${q}})()`)
                    } catch (e) {
                        teks = e
                    } finally {
                        await m.reply(require('util').format(teks))
                    }
                }

        }
    } catch (err) {
        console.log(require("util").format(err));
    }
};

let file = require.resolve(__filename)
require('fs').watchFile(file, () => {
  require('fs').unwatchFile(file)
  console.log('\x1b[0;32m'+__filename+' \x1b[1;32mupdated!\x1b[0m')
  delete require.cache[file]
  require(file)
})
